<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Ajax Search Module
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JLoader::register('ModVPAjaxSearchHelper', __DIR__ . '/helper.php');

$app              = JFactory::getApplication();
$doc              = JFactory::getDocument();
$Itemid           = $app->input->getInt('Itemid', 0);
$ajax_action_url  = JRoute::_('index.php?option=com_ajax&module=vp_ajax_search&method=get&format=json&Itemid=' . $Itemid);
$category_id      = ModVPAjaxSearchHelper::getCategoryId($params);
$action_url       = JRoute::_('index.php?option=com_virtuemart&view=category&search=true&limitstart=0&virtuemart_category_id=' . $category_id);
$text             = htmlspecialchars($params->get('text', JText::_('MOD_VP_AJAX_SEARCH_SEARCHBOX_TEXT')), ENT_COMPAT, 'UTF-8');
$moduleclass_sfx  = htmlspecialchars($params->get('moduleclass_sfx', ''), ENT_COMPAT, 'UTF-8');
$found_text       = htmlspecialchars($params->get('found_text', JText::_('MOD_VP_AJAX_SEARCH_PRODUCTS_FOUND_TEXT')), ENT_COMPAT, 'UTF-8');
$viewall_text     = htmlspecialchars($params->get('viewall_text', JText::_('MOD_VP_AJAX_SEARCH_VIEWALL_TEXT')), ENT_COMPAT, 'UTF-8');
$limit            = ModVPAjaxSearchHelper::getValidNumber($params, 'limit', 12);
$hidden_fields    = ModVPAjaxSearchHelper::getHiddenFields($params, $action_url);
$width_desktop    = ModVPAjaxSearchHelper::getWidthPerRow($params, 'items_per_row_desktop', 4);
$width_sm_desktop = ModVPAjaxSearchHelper::getWidthPerRow($params, 'items_per_row_desktop_small', 3);
$width_tablet     = ModVPAjaxSearchHelper::getWidthPerRow($params, 'items_per_row_tablet', 2);
$width_mobile     = ModVPAjaxSearchHelper::getWidthPerRow($params, 'items_per_row_mobile', 1);
$show_loader      = (int) $params->get('show_loader', 1);
$min_characters   = (int) $params->get('min_characters', 2);

require JModuleHelper::getLayoutPath('mod_vp_ajax_search', $params->get('layout', 'default'));