<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          http://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die('Restricted access');

$uri = JUri::base(true);
$document->addStyleSheet($uri . '/modules/mod_vp_compare/assets/css/module.css');
$document->addScript($uri . '/modules/mod_vp_compare/assets/js/module.js');
$document->addScriptDeclaration("
window.vp_compare_module_itemid = $menuid;
window.vp_compare_module_class = 'vp-compare{$moduleclass_sfx}';
");
?>
<div class="vp-compare<?php echo $moduleclass_sfx ?>">
	<div class="vp-compare-inner">
		<div class="vp-compare-anchor btn-jewel-group">
			<button type="button" class="btn-foricon<?php echo empty($product_count) ? ' empty' : ''; ?>"><i class="fa fa-shopping-cart fa-lg"></i></button>
			<?php if($product_count) : ?>
			<div class="jewel">
				<span class="product-count"><?php echo (int) $product_count ?></span>
			</div>
			<?php endif; ?>
		</div>
		<?php if($params->get('show_product_list', 1) && $product_count) : ?>
			<div class="vp-compare-dropdown">			
				<?php foreach($products as $product) : ?>
					<div class="row product-row">
						<div class="col-xs-3">
							<a href="<?php echo $product->url ?>">
								<?php echo !empty($product->images[0]) ? $product->images[0]->displayMediaThumb('', false) : ''; ?>
							</a>
						</div>
						<div class="col-xs-6">
							<?php echo JHtml::link ($product->url, $product->product_name); ?>
						</div>
						<?php if($params->get('show_price', 1) && $currencyDisplay->_priceConfig['salesPrice'][0]) : ?>
						<div class="col-xs-3">
							<?php echo $currencyDisplay->priceDisplay($product->prices['salesPrice']); ?>
						</div>
						<?php endif; ?>
					</div>	
				<?php endforeach; ?>
			</div>
		<?php endif; ?>
	</div>
</div>