<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Custom Filter Module - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Custom Filter Module
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       http://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined('_JEXEC') or die();

// Register VirtueMart config to Joomla autoloader
JLoader::register('VmConfig', JPATH_ROOT . '/administrator/components/com_virtuemart/helpers/config.php');

// Load VirtueMart Config and language
VmConfig::loadConfig();
VmConfig::loadJLang('com_virtuemart');

class JFormFieldVmfilters extends JFormField
{
	protected $type = 'vmfilters';
	
	protected $fieldXml = null;
	
	protected $customfields = null;
	
	protected $context = 'vmfilters';
	
	protected static $loaded = array();
	
	
	protected function getInput()
	{
		$sets          = (int) !empty($this->element['defaultsets']) ? $this->element['defaultsets'] : 1;
		$this->context = !empty($this->element['context']) ? $this->element['context'] : $this->context;
		$this->value   = !empty($this->value) ? (array) $this->value : array();

		self::_prepareJS($this->id, $this->name, $this->fieldname, $sets);
		
		$html  = '<span id="' . $this->id . '"></span>';
		
		if (version_compare(JVERSION, '3.0.0', 'ge'))
		{
			$html .= '</div></div>';
		}
		else
		{
			$html .= '</li></ul>';
		}
		
		$html .= '<ul class="vpdynamic-cont adminformlist">';
	
		if (!empty($this->element['description']))
		{
			$html .= '<div class="vpdynamic-toolbar">';
			$html .= '<div class="vpdynamic-desc">' . JText::_($this->element['description']) . '</div>';
			$html .= '</div>';
		}
		
		$html .= $this->getFieldSets();
		$html .= '</ul>';
		
		if (version_compare(JVERSION, '3.0.0', 'ge'))
		{
			$html .= '<div><div>';
		}
		else
		{
			$html .= '<ul class="adminformlist"><li>';
		}
		
		return $html;
	}
	
	protected function getFieldSets()
	{
		$forms = $this->getDynamicForms();
		
		if (empty($forms) || !is_array($forms))
		{
			return '';
		}
		
		$html     = array();
		$set_name = !empty($this->element['setlabel']) ? JText::_($this->element['setlabel']) . ': ' : 'Custom Field: ';

		foreach ($forms as $form)
		{
			foreach ($form->getFieldsets() as $group => $fieldset)
			{
				$fields = $form->getFieldset($group);
				
				if (count($fields))
				{
					$html[] = '<li>';
					$html[] = '<fieldset class="vpdynamic-fields-set" data-ordering="' . $fieldset->label . '">';
					
					$html[] = '<legend>' . $set_name . '<span class="vpdynamic-set-index">' . ($fieldset->label + 1) . '</span></legend>';
					
					$html[] = '<div class="vpdynamic-fields-button-cont">';
					$html[] = '<div class="btn btn-small vpdynamic-move-button hasTooltip" title="Move"><i class="icon-menu"></i></div>';
					$html[] = '</div>';
					$html[] = '<div class="clearfix"></div>';
					
					foreach ($fields as $field)
					{
						if ($field->hidden)
						{
							$html[] = $field->getInput();
						}
						else
						{
							$html[] = '<div class="control-group">';
							$html[] = '<div class="control-label">';
							$html[] = $field->getLabel();
							$html[] = '</div>';
							$html[] = '<div class="controls">';
							$html[] = $field->getInput();
							$html[] = '</div>';
							$html[] = '</div>';
						}
					}
					
					$html[] = '</fieldset>';
					$html[] = '</li>';
				}
			}
		}
		
		return implode($html);
	}
	
	protected function getDynamicForms()
	{
		$app = JFactory::getApplication();
		
		if ($this->fieldXml === null)
		{
			$xml       = JPath::clean(dirname(__FILE__) . '/vmfilters/fields.xml');
			$customXml = !empty($this->element['form']) ? JPath::clean(JPATH_BASE . '/' . $this->element['form']) : null;
			
			if (!empty($customXml) && is_file($customXml))
			{
				$xml = $customXml;
			}
			
			$this->fieldXml = file_get_contents($xml);
		}
		
		$forms        = array();
		$customfields = $this->getCustomFields();
		
		if (empty($customfields))
		{
			return $forms;
		}
		
		$count = count($customfields);
		
		if (empty($this->value))
		{
			$value = array_values($customfields);
		}
		else
		{
			$value = array();
			
			foreach ($this->value as $item)
			{
				$virtuemart_custom_id = $item['virtuemart_custom_id'];
				
				if (isset($customfields[$virtuemart_custom_id]))
				{
					$field = $customfields[$virtuemart_custom_id];
					
					$item['title'] = $field['title'];
					$item['type'] = $field['type'];
					$item['max_height'] = trim($item['max_height']);
					$item['max_height'] = $item['max_height'] ? (int) $item['max_height'] : $item['max_height'];
					
					$value[] = $item;
					
					unset($customfields[$virtuemart_custom_id]);
				}
			}
			
			if (!empty($customfields))
			{
				$value = array_merge($value, $customfields);
			}
		}
		
		for($i = 0; $i < $count; $i++)
		{
			$xml  = '<?xml version="1.0" encoding="utf-8"?>';
			$xml .= '<form>';
			$xml .= '<fieldset name="set_' . $i . '" label="' .$i . '">';
			$xml .= $this->fieldXml;
			$xml .= '</fieldset>';
			$xml .= '</form>';
			
			$form = JForm::getInstance($this->context . '.fields.' . $i, $xml, array('control' => $this->name . '[' . $i . ']'));
			
			if (isset($value[$i]))
			{
				$form->bind($value[$i]);
			}
			
			$forms[] = $form;
		}
		
		return $forms;
	}
	
	protected function getCustomFields()
	{
		if ($this->customfields === null)
		{
			$db    = JFactory::getDbo();
			$query = $db->getQuery(true);
			$types = array('S', 'I', 'B', 'D', 'T', 'V');
			
			$query->select('`virtuemart_custom_id`, `custom_title` AS title, `field_type` AS type')
			      ->from('`#__virtuemart_customs`')
			      ->where('`published` = 1')
			      ->where('`field_type` IN (' . implode(',', $db->quote($types)) . ')');
			$db->setQuery($query);
			$this->customfields = $db->loadAssocList('virtuemart_custom_id');
		}
		
		return $this->customfields;
	}
	
	protected static function _prepareJS($id, $name, $fieldname, $sets)
	{
		// Only load once
		if (isset(static::$loaded[__METHOD__]))
		{
			return;
		}
		
		$joomla3 = version_compare(JVERSION, '3.0.0', 'ge') ? '1' : '0';
		
		if (version_compare(JVERSION, '4.0.0', 'ge'))
		{
			JHtml::_('script', 'vpframework/jquery.ui.core.min.js', array('relative' => true));
			JHtml::_('script', 'vpframework/jquery.ui.sortable.min.js', array('relative' => true));
			JHtml::_('script', 'vpframework/sortablelist.js', array('relative' => true));
			
			JHtml::_('stylesheet', 'vpframework/sortablelist.css', array('relative' => true));
		}
		else
		{
			JHtml::_('jquery.ui', array('core', 'sortable'));
			JHtml::_('script', 'jui/sortablelist.js', array('relative' => true));
			
			JHtml::_('stylesheet', 'jui/sortablelist.css', array('relative' => true));
		}
		
		$js = "
		jQuery(document).ready(function($) {
			var joomla3 = " . $joomla3 . ";
			if (joomla3) {
				$('span#" . $id . "').closest('.control-group').hide();
			} else {
				$('span#" . $id . "').closest('li').hide();
			}
			$('.vpdynamic-cont').sortable({
				axis: 'y'
			});
			$('.vpdynamic-cont').on('sortupdate', function(event, ui) {
				var fieldset, oldOrdering;
				$(this).children('li').each(function(index, element) {
					fieldset = $('fieldset.vpdynamic-fields-set', this);
					oldOrdering = fieldset.data('ordering');
					fieldset.data('ordering', index).attr('data-ordering', index);
					$(this).find('label, input, select, textarea, a, div.chzn-container').each(function() {
						if ($(this).attr('name')) {
							$(this).attr('name', $(this).attr('name').replace('" . $name . "[' + oldOrdering + ']', '" . $name . "[' + index  + ']'));
						}
						if ($(this).attr('id')) {
							$(this).attr('id', $(this).attr('id').replace('" . $fieldname . "__' + oldOrdering, '" . $fieldname . "__' + index));
						}
						if ($(this).attr('href')) {
							$(this).attr('href', $(this).attr('href').replace('" . $fieldname . "__' + oldOrdering, '" . $fieldname . "__' + index));
						}
						if ($(this).attr('onclick')) {
							$(this).attr('onclick', $(this).attr('onclick').replace('" . $fieldname . "__' + oldOrdering, '" . $fieldname . "__' + index));
						}
						if ($(this).attr('for')) {
							$(this).attr('for', $(this).attr('for').replace('" . $fieldname . "__' + oldOrdering, '" . $fieldname . "__' + index));
						}
					});
					$('.vpdynamic-set-index', this).fadeOut(function() {
						$(this).text(index + 1).fadeIn();
					});
				});
				if ($(this).children('li').length <= " . $sets . ") {
					$('.vpdynamic-remove-button', this).attr('disabled', true);
				} else {
					$('.vpdynamic-remove-button', this).removeAttr('disabled');
				}
			});
			$('.vpdynamic-cont').trigger('sortupdate');
			$('.vpdynamic-addnew-button').click(function(){
				var group = $(this).parents('.vpdynamic-cont');
				if (joomla3) {
					$('.vpdynamic-cont select').each(function(){
						$(this).chosen('destroy');
					})
					$('.vpdynamic-cont .hasTooltip').each(function(){
						$(this).tooltip('destroy');
					});
				}
				var newSet = $('li:last-child', group).clone(true);
				$('select', newSet).prop('selectedIndex', '');
				$('select[multiple]', newSet).val('');
				$('input:text,textarea', newSet).val('');
				group.append(newSet);
				group = $(this).parents('.vpdynamic-cont');
				group.trigger('sortupdate');
				if (joomla3) {
					$('.vpdynamic-cont select').each(function(){
						$(this).chosen({'disable_search_threshold':10,'allow_single_deselect':true,'placeholder_text_multiple':'Select some options','placeholder_text_single':'Select an option','no_results_text':'No results match'});
					});
					$('.vpdynamic-cont .hasTooltip').each(function(){
						$(this).tooltip({'html': true,'container': 'body'});
					});
				}
				$('html,body').animate({
					scrollTop: $('li:last-child', group).offset().top - 200
				}, 500);
			});
			$('.vpdynamic-remove-button').click(function(){
				var group = $(this).parents('.vpdynamic-cont');
				$(this).parents('li').animate({'opacity' : 0}, 500, function(){
					$(this).remove();
					group.trigger('sortupdate');
				});
			})
		});
		";
		
		$css = "ul.vpdynamic-cont{list-style:none;padding:0;margin:0}.vpdynamic-fields-set{position:relative;margin-bottom:15px;}.vpdynamic-fields-button-cont{position:absolute;top:0;right:0}.vpdynamic-fields-button-cont .btn{margin-left:10px}.vpdynamic-toolbar{margin-bottom:20px}.vpdynamic-toolbar .btn{padding-left:35px;padding-right:35px}.vpdynamic-move-button{padding:3px 4px 1px 5px;cursor:move}.vpdynamic-fields-set{background-color:#FFF;opacity:1}.ui-sortable-helper .vpdynamic-fields-set{opacity:0.8}.vpdynamic-toolbar{text-align:right}.vpdynamic-desc{float:left;margin-bottom:10px;text-align:left}.vpdynamic-fields-set legend{font-size:1.2em;font-weight:700;}";

		$doc = JFactory::getDocument();
		
		$doc->addScriptDeclaration($js);
		$doc->addStyleDeclaration($css);
	}
}