<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Custom Filter Module - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Custom Filter Module
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       http://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/

defined('_JEXEC') or die;

// Register VirtueMart config to Joomla autoloader
JLoader::register('VmConfig', JPATH_ROOT . '/administrator/components/com_virtuemart/helpers/config.php');
JLoader::register('vmJsApi', JPATH_ROOT . '/administrator/components/com_virtuemart/helpers/vmjsapi.php');

// Load VirtueMart Config and language
VmConfig::loadConfig();

/**
 * Form Field class for the Joomla Platform.
 * Displays options as a list of check boxes.
 * Multiselect may be forced to be true.
 *
 * @see    JFormFieldCheckbox
 * @since  11.1
 */
class JFormFieldVpcfprice extends JFormField
{
	/**
	 * The form field type.
	 *
	 * @var    string
	 * @since  11.1
	 */
	protected $type = 'Vpcfprice';

	/**
	 * The comma seprated list of checked checkboxes value.
	 *
	 * @var    mixed
	 * @since  3.2
	 */
	public $checkedOptions;
	
	/**
	 * Method to get certain otherwise inaccessible properties from the form field object.
	 *
	 * @param   string  $name  The property name for which to the the value.
	 *
	 * @return  mixed  The property value or null.
	 *
	 * @since   3.2
	 */
	public function __get($name)
	{
		switch ($name)
		{
			case 'id_prefix':
			case 'symbol':
			case 'decimal_place':
			case 'decimal_symbol':
			case 'thousands':
			case 'style':
			case 'show_clear':
			case 'step':
			case 'clear_url':
				return $this->$name;
		}

		return parent::__get($name);
	}

	/**
	 * Method to set certain otherwise inaccessible properties of the form field object.
	 *
	 * @param   string  $name   The property name for which to the the value.
	 * @param   mixed   $value  The value of the property.
	 *
	 * @return  void
	 *
	 * @since   3.2
	 */
	public function __set($name, $value)
	{
		switch ($name)
		{
			case 'id_prefix':
			case 'symbol':
			case 'decimal_place':
			case 'decimal_symbol':
			case 'thousands':
			case 'style':
			case 'show_clear':
			case 'step':
			case 'clear_url':
				$this->$name = (string) $value;
				break;

			default:
				parent::__set($name, $value);
		}
	}

	/**
	 * Method to get the radio button field input markup.
	 *
	 * @return  string  The field input markup.
	 *
	 * @since   11.1
	 */
	protected function getInput()
	{
		$xmlOptions = $this->element->xpath('option');

		if (empty($xmlOptions))
		{
			return '';
		}
		
		$this->id_prefix      = (string) $this->element['id_prefix'];
		$this->symbol         = (string) $this->element['symbol'];
		$this->decimal_place  = (string) $this->element['decimal_place'];
		$this->decimal_symbol = (string) $this->element['decimal_symbol'];
		$this->thousands      = (string) $this->element['thousands'];
		$this->style          = (string) $this->element['style'];
		$this->show_clear     = (int) $this->element['show_clear'];
		$this->step           = $this->element['step'];
		$this->clear_url      = (string) $this->element['clear_url'];
		$this->id             = $this->id_prefix . '_' . $this->id;
		$nofollow             = isset($this->element['nofollow']) ? (int) $this->element['nofollow'] : 0;
		
		$fieldname = preg_replace('/[^a-zA-Z0-9_\-]/', '_', $this->fieldname);
		$options   = array();
		$hasValue  = (isset($this->value) && !empty($this->value));

		$min_price = 0;
		$max_price = 0;
		
		foreach ($xmlOptions as $option)
		{
			$value = (string) $option['value'];
			$text  = trim((string) $option) ? trim((string) $option) : $value;
			$url   = (string) $option['url'];
			
			if ($value == '0')
			{
				$min_price = (float) $text;
			}
			elseif ($value == '1')
			{
				$max_price = (float) $text;
			}
		}
		
		if (empty($max_price) || ($max_price - $min_price) < 1)
		{
			return '';
		}
		
		$current_min = !empty($this->value[0]) ? $this->value[0] : $min_price;
		$current_max = !empty($this->value[1]) ? $this->value[1] : $max_price;
		
		$data = array();
		
		$data[] = 'data-minprice="' . $min_price . '"';
		$data[] = 'data-maxprice="' . $max_price . '"';
		$data[] = 'data-currentmin="' . $current_min . '"';
		$data[] = 'data-currentmax="' . $current_max . '"';
		$data[] = 'data-symbol="' . $this->symbol . '"';
		$data[] = 'data-decimals="' . $this->decimal_place . '"';
		$data[] = 'data-decimalpoint="' . $this->decimal_symbol . '"';
		$data[] = 'data-thousands="' . $this->thousands . '"';
		$data[] = 'data-step="' . $this->step . '"';
		$data[] = 'data-style="' . htmlspecialchars($this->style, ENT_COMPAT, 'UTF-8') . '"';
		
		$data = implode(' ', $data);
		
		$html = array();
		
		$html[] = '<fieldset id="' . $this->id . '" class="' . trim($this->class . ' vpfc-price-range') . '"' .
		          ($this->required ? ' required aria-required="true"' : '') .
		          ($this->autofocus ? ' autofocus' : '') . '>';
		          
		if ($this->show_clear && !empty($this->clear_url) && (($current_min != $min_price) || ($current_max != $max_price)))
		{
			$html[] = '<div class="vpcf-clear-cont">';
			$html[] = '<a href="' . htmlspecialchars($this->clear_url, ENT_COMPAT, 'UTF-8') . '" data-vpcfurl="true"' . ($nofollow ? ' rel="nofollow"' : '') . '><span class="vpcf-clearmark">&#10005;</span>' . JText::_('PLG_SYSTEM_VPFRAMEWORK_CLEAR_FILTER') . '</a>';
			$html[] = '</div>';
		}
		
		$html[] = '<div id="' . $this->id . '-range" data-vpfc-slider="true" ' . $data . '></div>';
		
		$html[] = '<div class="vpfv-price-amount vpcf-options">';
		$html[] = '<span class="text-muted">' . JText::_('PLG_SYSTEM_VPFRAMEWORK_PRICE_RANGE') . ': </span>';
		$html[] = '<b class="from"></b> &mdash; <b class="to"></b>';
		$html[] = '</div>';
		
		$html[] = '<input type="hidden" name="' . $this->name . '[0]" data-minprice="input" value="' . $current_min . '" disabled="true" />';
		$html[] = '<input type="hidden" name="' . $this->name . '[1]" data-maxprice="input" value="' . $current_max . '" disabled="true" />';
		$html[] = '</fieldset>';
		
		vmJsApi::jQuery();
		vmJsApi::jQueryUi();
		
		return implode($html);
	}
	
	/**
	 * Method to attach a JForm object to the field.
	 *
	 * @param   SimpleXMLElement  $element  The SimpleXMLElement object representing the `<field>` tag for the form field object.
	 * @param   mixed             $value    The form field value to validate.
	 * @param   string            $group    The field name group control value. This acts as as an array container for the field.
	 *                                      For example if the field has name="foo" and the group value is set to "bar" then the
	 *                                      full field name would end up being "bar[foo]".
	 *
	 * @return  boolean  True on success.
	 *
	 * @see     JFormField::setup()
	 * @since   3.2
	 */
	public function setup(SimpleXMLElement $element, $value, $group = null)
	{
		$return = parent::setup($element, $value, $group);

		if ($return)
		{
			$this->checkedOptions = (string) $this->element['checked'];
		}

		return $return;
	}
}
