<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Custom Filter Module - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Custom Filter Module
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       http://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/

defined('_JEXEC') or die;

class JFormFieldVPGroupHeading extends JFormField
{
	protected $type = 'VPGroupHeading';

	public function getInput()
	{
		return '';
	}
	
	public function getLabel()
	{
		$class = isset($this->element['class']) ? ' ' . $this->element['class'] : '';
		$html = '<h4 class="vp-group-heading' . htmlspecialchars($class) . '">' . JText::_($this->element['label']) . '</h4>';
		
		if (!empty($this->element['description']))
		{
			$html .= '<div class="vp-group-heading-desc' . htmlspecialchars($class) . '"><span class="muted">' . JText::_($this->element['description']) . '</span></div>';
		}
		
		return $html;
	}
}