<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Custom Filter Module - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Custom Filter Module
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       http://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined('_JEXEC') or die;

$app     = JFactory::getApplication();
$input   = $app->input;
$show_in = $params->get('show_in', 'category');
$option  = strtolower($input->getCmd('option', ''));
$view    = strtolower($input->getCmd('view', ''));
$show    = false;

if ($show_in == 'category')
{
	if ($option == 'com_virtuemart' && $view == 'category')
	{
		$menus = $app->getMenu();
		$menu  = $menus->getActive();
		
		if (empty($menu->id) && ($itemId = $input->getInt('Itemid', 0)))
		{
			$menus->setActive($itemId);
			$menu = $menus->getActive();
		}
		
		if ($menu && property_exists($menu, 'query'))
		{
			if (!isset($menu->query['showproducts']))
			{
				$menu->query['showproducts'] = 1;
			}
			
			$showProducts = $input->getInt('showproducts', $menu->query['showproducts']);
		}
		else
		{
			$showProducts = $input->getInt('showproducts', 1);
		}

		if ($showProducts)
		{
			$show = true;
		}
	}
}
else
{
	$show = true;
}

if ($show)
{
	JLoader::register('ModVPCustomFilterHelper', __DIR__ . '/helper.php');
	
	$doc             = JFactory::getDocument();
	$helper          = new ModVPCustomFilterHelper($params);
	$form            = $helper->getFilters($module->id);
	$filters         = $form->getFieldsets();
	$hiddenFields    = $helper->getHiddenFields();
	$actionUrl       = $helper->getActionUrl();
	$use_ajax        = (int) $params->get('use_ajax', 0);
	$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx', ''));

	if (!empty($filters))
	{
		require JModuleHelper::getLayoutPath('mod_vp_custom_filter', $params->get('layout', 'default'));
	}
}
