<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Mini Cart Module - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Mini Cart Module
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       http://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined('_JEXEC') or die('Restricted access');

vmJsApi::jQuery();
$uri = JUri::base(true);
$document->addStyleSheet($uri . '/modules/mod_vp_mini_cart/assets/css/module.css');
$document->addScript($uri . '/modules/mod_vp_mini_cart/assets/js/module.js');
$document->addScriptDeclaration("
if (typeof window.juri === 'undefined' || typeof window.juri === undefined) {
	window.juri = '{$uri}/index.php';
}
window.vp_minicart_module_itemid = $menuid;
window.vp_minicart_module_class = 'vp-minicart{$moduleclass_sfx}';
");
?>
<div class="vp-minicart<?php echo $moduleclass_sfx ?>">
	<div class="vp-minicart-inner">
		<div class="vp-minicart-anchor btn-jewel-group">
			<button type="button" class="btn-foricon<?php echo empty($product_count) ? ' empty' : ''; ?>"><div class="minicart-icon"></div></button>
			<div class="jewel onhide<?php echo empty($product_count) ? ' hide' : ''; ?>">
				<span class="product-count"><?php echo (int) $product_count ?></span>
			</div>
		</div>		
		<div class="vp-minicart-dropdown">
			<?php if ($params->get('show_product_list', 1) && $product_count) : ?>
				<?php foreach ($cart->products as $pkey => $product) : ?>
					<div class="row product-row">
						<div class="col-xs-3">
							<a href="<?php echo $product->url ?>">
								<?php echo !empty($product->images[0]) ? $product->images[0]->displayMediaThumb('', false) : ''; ?>
							</a>
						</div>
						<div class="col-xs-6">
							<?php echo JHtml::link ($product->url, $product->product_name) . $customfieldsModel->CustomsFieldCartDisplay($product); ?>
						</div>
						<?php if ($params->get('show_price', 1) && $currencyDisplay->_priceConfig['salesPrice'][0]) : ?>
						<div class="col-xs-3">
							<?php echo $currencyDisplay->priceDisplay($product->allPrices[$product->selectedPrice]['subtotal_with_tax']); ?>
						</div>
						<?php endif; ?>						
					</div>	
				<?php endforeach; ?>
			<?php endif; ?>		
		</div>		
	</div>
</div>

