<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Product Carousel - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Product Carousel
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       https://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined('JPATH_BASE') or die;

jimport('joomla.form.formfield');
JFormHelper::loadFieldClass('list');

class JFormFieldVMPrices extends JFormFieldList
{
	public $type = 'VMPrices';

	protected function getOptions()
	{
		JLoader::register('VmConfig', JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/config.php');
		
		VmConfig::loadConfig();
		VmConfig::loadJLang('com_virtuemart');
		VmConfig::loadJLang('com_virtuemart_config');

		$options = array();
		$disabled  = VmConfig::get('basePrice', 0) ? false : true;
		$options[] = JHtml::_('select.option', 'basePrice', vmText::_('COM_VIRTUEMART_ADMIN_CFG_PRICE_BASEPRICE'), 'value', 'text', $disabled);
		$disabled  = VmConfig::get('basePriceVariant', 0) ? false : true;
		$options[] = JHtml::_('select.option', 'basePriceVariant', vmText::_('COM_VIRTUEMART_ADMIN_CFG_PRICE_BASEPRICE_VAR'), 'value', 'text', $disabled);
		$disabled  = VmConfig::get('variantModification', 0) ? false : true;
		$options[] = JHtml::_('select.option', 'variantModification', vmText::_('COM_VIRTUEMART_ADMIN_CFG_PRICE_VARMOD'), 'value', 'text', $disabled);
		$disabled  = VmConfig::get('basePriceWithTax', 0) ? false : true;
		$options[] = JHtml::_('select.option', 'basePriceWithTax', vmText::_('COM_VIRTUEMART_ADMIN_CFG_PRICE_BASEPRICE_WTAX'), 'value', 'text', $disabled);
		$disabled  = VmConfig::get('salesPriceWithDiscount', 0) ? false : true;
		$options[] = JHtml::_('select.option', 'salesPriceWithDiscount', vmText::_('COM_VIRTUEMART_ADMIN_CFG_PRICE_SALESPRICE_WD'), 'value', 'text', $disabled);
		$disabled  = VmConfig::get('salesPrice', 0) ? false : true;
		$options[] = JHtml::_('select.option', 'salesPrice', vmText::_('COM_VIRTUEMART_ADMIN_CFG_PRICE_SALESPRICE'), 'value', 'text', $disabled);
		$disabled  = VmConfig::get('salesPriceTt', 0) ? false : true;
		$options[] = JHtml::_('select.option', 'salesPriceTt', vmText::_('COM_VIRTUEMART_ADMIN_CFG_PRICE_SALESPRICE_TT'), 'value', 'text', $disabled);
		$disabled  = VmConfig::get('discountedPriceWithoutTax', 0) ? false : true;
		$options[] = JHtml::_('select.option', 'discountedPriceWithoutTax', vmText::_('COM_VIRTUEMART_ADMIN_CFG_PRICE_DISCPRICE_WOTAX'), 'value', 'text', $disabled);
		$disabled  = VmConfig::get('discountedPriceWithoutTaxTt', 0) ? false : true;
		$options[] = JHtml::_('select.option', 'discountedPriceWithoutTaxTt', vmText::_('COM_VIRTUEMART_ADMIN_CFG_PRICE_DISCPRICE_WOTAX_TT'), 'value', 'text', $disabled);
		$disabled  = VmConfig::get('priceWithoutTax', 0) ? false : true;
		$options[] = JHtml::_('select.option', 'priceWithoutTax', vmText::_('COM_VIRTUEMART_ADMIN_CFG_PRICE_SALESPRICE_WOTAX'), 'value', 'text', $disabled);
		$disabled  = VmConfig::get('priceWithoutTaxTt', 0) ? false : true;
		$options[] = JHtml::_('select.option', 'priceWithoutTaxTt', vmText::_('COM_VIRTUEMART_ADMIN_CFG_PRICE_SALESPRICE_WOTAX_TT'), 'value', 'text', $disabled);
		$disabled  = VmConfig::get('discountAmount', 0) ? false : true;
		$options[] = JHtml::_('select.option', 'discountAmount', vmText::_('COM_VIRTUEMART_ADMIN_CFG_PRICE_DISC_AMOUNT'), 'value', 'text', $disabled);
		$disabled  = VmConfig::get('taxAmount', 0) ? false : true;
		$options[] = JHtml::_('select.option', 'taxAmount', vmText::_('COM_VIRTUEMART_ADMIN_CFG_PRICE_TAX_AMOUNT'), 'value', 'text', $disabled);
		$disabled  = VmConfig::get('taxAmountTt', 0) ? false : true;
		$options[] = JHtml::_('select.option', 'taxAmountTt', vmText::_('COM_VIRTUEMART_ADMIN_CFG_PRICE_TAX_AMOUNT_TT'), 'value', 'text', $disabled);
		$disabled  = VmConfig::get('unitPrice', 0) ? false : true;
		$options[] = JHtml::_('select.option', 'unitPrice', vmText::_('COM_VIRTUEMART_ADMIN_CFG_PRICE_UNITPRICE'), 'value', 'text', $disabled);

		return array_merge(parent::getOptions(), $options);
	}
}