<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Product Carousel - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Product Carousel
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       https://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined('_JEXEC') or die('Restricted access');

$vpframework  = false;
$listMode     = '';
$customClass  = 'product-cart-variants';
$stockhandle  = VmConfig::get('stockhandle', 'none');
$costPrice    = (float) $product->prices['costPrice'];
$salesPrice   = (float) $product->prices['salesPrice'];
$tmpPrice     = !empty($costPrice) && !empty($salesPrice);
$step         = isset($product->step_order_level) ? $product->step_order_level : 1;
$step         = (empty($step)) ? 1 : $step;
$btn_lg       = 'btn-md';
$addtoCartButton = '';
if (!VmConfig::get('use_as_catalog', 0))
{
	if (isset($product->addToCartButton) && !empty($product->addToCartButton))
	{
		$addtoCartButton = $product->addToCartButton;
	} 
	else 
	{
		$addtoCartButton = shopFunctionsF::getAddToCartButton($product->orderable);
	}
	
	if (strpos($addtoCartButton, 'class=') !== false)
	{
		$addtoCartButton = str_replace('class="', 'class="hasTooltip btn btn-primary btn-addtocart ' . $btn_lg . ' ', $addtoCartButton);
	}
	else
	{
		$addtoCartButton = str_replace('type=', 'class="hasTooltip btn btn-primary btn-addtocart ' . $btn_lg . '" type=', $addtoCartButton);
	}
}

$dummyAddtoCartButton = '';
if (!empty($addtoCartButton) && !empty($product->customfieldsSorted['addtocart']))
{
	$dummyAddtoCartButton = $addtoCartButton;
	$addtoCartButton = str_replace('btn-addtocart ' . $btn_lg . '', 'btn-addtocart ' . $btn_lg . ' hide', $addtoCartButton);
	if (strpos($dummyAddtoCartButton, 'addtocart-button-disabled') !== false)
	{
		$dummyAddtoCartButton = str_replace(array('type="submit"', 'hasTooltip btn btn-primary btn-addtocart ' . $btn_lg . ' addtocart-button-disabled'), array('type="button"', 'hasTooltip btn btn-primary btn-addtocart ' . $btn_lg . ' btn-showvariants'), $dummyAddtoCartButton);
	}
	else
	{
		$dummyAddtoCartButton = str_replace(array('type="submit"', 'hasTooltip btn btn-primary btn-addtocart ' . $btn_lg . ' addtocart-button'), array('type="button"', 'hasTooltip btn btn-primary btn-addtocart ' . $btn_lg . ' btn-showvariants'), $dummyAddtoCartButton);
	}
}
?>
<div class="addtocart-area">
	<form method="post" class="product js-recalculate" action="<?php echo JRoute::_('index.php', false); ?>">
	
		<?php require JModuleHelper::getLayoutPath('mod_vp_product_carousel', $params->get('layout', 'default') . '_customfields'); ?>
		<?php //echo shopFunctionsF::renderVmSubLayout('customfields', array('product' => $product, 'position' => 'addtocart', 'class' => $customClass, 'isList' => true)); ?>

		<?php if (!VmConfig::get('use_as_catalog', 0)) : ?>
			<div class="addtocart-bar clearfix is-list">
			
				<?php if (($stockhandle == 'disableit' || $stockhandle == 'disableadd') && ($product->product_in_stock - $product->product_ordered) < 1 && !empty($tmpPrice)) : ?>
					<a href="<?php echo JRoute::_('index.php?option=com_virtuemart&view=productdetails&layout=notify&virtuemart_product_id=' . $product->virtuemart_product_id); ?>" class="btn btn-notify <?php echo $btn_lg ?> hasTooltip"><?php echo vmText::_ ('COM_VIRTUEMART_CART_NOTIFY') ?></a>
				<?php else : ?>
					<?php if (!(VmConfig::get('askprice', true) && empty($tmpPrice)) && $product->orderable) : ?>
						<?php
						// Build Input Box HTML
						$inputbox  = '<input type="text" class="form-control input-lg quantity-input js-recalculate" name="quantity[]" ';
						$inputbox .= 'onblur="Virtuemart.checkQuantity(this, ' . $step . ', \'' . vmText::_ ('COM_VIRTUEMART_WRONG_AMOUNT_ADDED') . '\');" ';
						$inputbox .= 'onclick="Virtuemart.checkQuantity(this, ' . $step . ', \'' . vmText::_ ('COM_VIRTUEMART_WRONG_AMOUNT_ADDED') . '\');" ';
						$inputbox .= 'onchange="Virtuemart.checkQuantity(this, ' . $step . ', \'' . vmText::_ ('COM_VIRTUEMART_WRONG_AMOUNT_ADDED') . '\');" ';
						$inputbox .= 'onsubmit="Virtuemart.checkQuantity(this, ' . $step . ', \'' . vmText::_ ('COM_VIRTUEMART_WRONG_AMOUNT_ADDED') . '\');" ';
						if (isset($product->step_order_level) && (int)$product->step_order_level > 0)
						{
							$value = $product->step_order_level;
						}
						elseif (!empty($product->min_order_level))
						{
							$value = $product->min_order_level;
						}
						else
						{
							$value = 1;
						}
						$inputbox .= 'value="' . $value . '"/>';
						$hideClass = !$params->get('vm_show_qty', 0) ? ' hide' : '';
						?>
						<span class="quantity-box-cont quantity-box<?php echo $hideClass ?>">
							<?php echo $inputbox ?>
						</span>
						<span class="quantity-controls-cont quantity-controls js-recalculate<?php echo $hideClass ?>">
							<button type="button" class="quantity-controls quantity-plus"><i class="icon-arrow-up"></i></button>
							<button type="button" class="quantity-controls quantity-minus"><i class="icon-arrow-down"></i></button>
						</span>
					<?php endif; ?>
					
					<?php if (!(VmConfig::get('askprice', true) && empty($tmpPrice)) && !empty($addtoCartButton)) : ?>
						<span class="addtocart-button-cont">
							<?php echo $addtoCartButton; ?>
							<?php echo $dummyAddtoCartButton; ?>
						</span>
						<noscript><input type="hidden" name="task" value="add"/></noscript>
					<?php endif; ?>
					
					<?php if ($vpframework) : ?>
						<span class="product-action-buttons pull-right">
							<button type="button" class="vpf-quickview-btn btn btn-foricon hasTooltip" title="<?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_QUICKVIEW_LABEL') ?>" data-productid="<?php echo $product->virtuemart_product_id ?>" data-catid="<?php echo $product->virtuemart_category_id ?>">
								<i class="icon-zoomin2 icon-lg"></i><span class="sr-only"><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_QUICKVIEW_LABEL') ?></span>
							</button>
							<button type="button" class="vpf-addtowishlist-btn btn btn-foricon hasTooltip" title="<?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_WISHLIST_ADD_TO_LABEL') ?>" data-productname="<?php echo $product->product_name ?>" data-productid="<?php echo $product->virtuemart_product_id ?>">
								<i class="icon-heart3 icon-lg"></i><span class="sr-only"><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_WISHLIST_ADD_TO_LABEL') ?></span>
							</button>
							<button type="button" class="vpf-addtocompare-btn btn btn-foricon hasTooltip" title="<?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_COMPARE_ADD_TO_LABEL') ?>" data-productname="<?php echo $product->product_name ?>" data-productid="<?php echo $product->virtuemart_product_id ?>">
								<i class="icon-interset icon-lg"></i><span class="sr-only"><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_COMPARE_ADD_TO_LABEL') ?></span>
							</button>
						</span>
					<?php endif; ?>
					
				<?php endif; ?>
			</div>
		<?php endif; ?>
		<input type="hidden" name="option" value="com_virtuemart"/>
		<input type="hidden" name="view" value="cart"/>
		<input type="hidden" name="virtuemart_product_id[]" value="<?php echo $product->virtuemart_product_id ?>"/>
		<input type="hidden" class="pname" value="<?php echo $product->product_name ?>"/>
		<?php if ($itemId = $input->getInt('Itemid', 0)) : ?>
			<input type="hidden" name="Itemid" value="<?php echo $itemId ?>"/>
		<?php endif; ?>
	</form>
</div>