<?php
/**
 * --------------------------------------------------------------------------------------------
 * VP Product Carousel - Joomla! 3 Module for VirtueMart 3.0
 * --------------------------------------------------------------------------------------------
 * @package    VP Product Carousel
 * @author     Abhishek Das
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2. http://www.gnu.org/licenses/gpl-2.0.html
 * @link       https://www.virtueplanet.com
 * --------------------------------------------------------------------------------------------
*/
defined('_JEXEC') or die;

JLoader::register('VmConfig', JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/config.php');
JLoader::register('ModVPProductListHelper', __DIR__ . '/helper.php');

VmConfig::loadConfig();

$app                     = JFactory::getApplication();
$template                = $app->getTemplate();
$input                   = $app->input;
$vendorId                = $input->getInt('vendorid', 1);
$virtuemart_currency_id  = $app->getUserStateFromRequest('virtuemart_currency_id', 'virtuemart_currency_id', $input->getInt('virtuemart_currency_id', 0));
$show_price              = $params->get('show_price', 1);
$showRating              = $params->get('show_rating', 1);
$currency                = CurrencyDisplay::getInstance();
$moduleclass_sfx         = htmlspecialchars($params->get('moduleclass_sfx', ''));
$module_id               = 'vp-product-list-' . $module->id;
$cacheEnabled            = $params->get('vpcache', 1);
$cacheEnabled            = ($params->get('product_group', '') == 'recent') ? false : $cacheEnabled;
$cache_time              = $params->get('vpcache_time', 300);
$doc                     = JFactory::getDocument();
$base                    = JUri::base(true);
$key                     = 'id:' . $module->id . 'params:' . serialize($params->toArray());
$cache                   = JFactory::getCache('mod_vp_product_list', 'output');

if (!empty($cache_time))
{
	$cache->setLifeTime($cache_time);
}

if (!$cacheEnabled)
{
	$cache->setCaching(0);
}

// Try to get the output from cache
$output = $cache->get($key);

if (empty($output))
{
	$products = ModVPProductListHelper::getList($params);
	$output = '';
	
	if (!empty($products))
	{
		$total = count($products);
		
		ob_start();
		
		require JModuleHelper::getLayoutPath('mod_vp_product_list', $params->get('layout', 'default'));
		
		$output = ob_get_clean();
	}
	
	$cache->store($output, $key);
}

if (!empty($output))
{
	// Start module output
	JHtml::_('jquery.framework');

	if (file_exists(JPATH_SITE . '/templates/' . $template . '/css/mod_vp_product_list/module.css'))
	{
		$doc->addStyleSheet($base . '/templates/' . $template . '/css/mod_vp_product_list/module.css');
	}
	else
	{
		$doc->addStyleSheet($base . '/modules/mod_vp_product_list/assets/css/module.css');
	}

	$maxrating  = VmConfig::get('vm_maximum_rating_scale', 5);
	$hint       = array();

	for($i=1; $i<=$maxrating; $i++)
	{
		$hint[] = "'" . $i . " " . vmText::_('COM_VIRTUEMART_REVIEW_STARS') . "'";
	}

	$hint   = '[' . implode(',', $hint) . ']';
	$rateJS = "
	  jQuery(document).ready(function($) {
	    $('.vm-product-list-rating').raty({
	      score: function() {
	        return $(this).data('score') ? $(this).data('score') : 0;
	      },
	      numberMax: " . $maxrating . ",
	      number: " . $maxrating . ",
	      hints: " . $hint . ",
	      starType: 'i',
	      halfShow: true,
	      readOnly: true,
	      noRatedMsg: '" . vmText::_('COM_VIRTUEMART_UNRATED') . "'
	    });
	  });
	";

	vmJsApi::addJScript('ModVPProductListRating', $rateJS);
	
	echo $output;
	echo vmJsApi::writeJS();
}