<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die('Restricted access');

$app = JFactory::getApplication();
$input = $app->input;
$ajax = 1;
$option = $app->getUserStateFromRequest('mod_vp_wishlist.option', 'option', null, 'CMD');
$view = $app->getUserStateFromRequest('mod_vp_wishlist.view', 'view', null, 'CMD');
$id = $app->getUserStateFromRequest('mod_vp_wishlist.id', 'id', null, 'INT');
if ($option == 'com_content' && $view == 'article' && $id == $article_id)
{
	$ajax = 0;
}
$document->addScriptDeclaration("
window.vp_wishlist_module_itemid = $menuid;
window.vp_wishlist_module_class = 'vp-wishlist{$moduleclass_sfx}';
");
?>
<div class="vp-wishlist<?php echo $moduleclass_sfx ?>">
	<div class="vp-dropmod-container">
		<div class="vp-dropmod-anchor btn-jewel-group">
			<a class="btn btn-foricon btn-base<?php echo ($user->guest || empty($product_count)) ? ' empty' : ''; ?>"><i class="icon-interset icon-lg"></i></a>
			<?php if (!$user->guest && !empty($product_count)) : ?>
			<div class="jewel jewel-top jewel-invert">
				<span class="product-count"><?php echo (int) $product_count ?></span>
			</div>
			<?php endif; ?>
		</div>
		<div class="vp-dropmod-inner">
			<div class="vp-dropmod-contents">
				<?php if ($user->guest) : ?>
					<div class="vp-dropmod-header empty">
						<div class="row row-mini">
							<div class="col-xs-12 align-center">
								<?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_WISHLIST_VIEW_NEED_LOGIN') ?>
							</div>
						</div>
					</div>
				<?php elseif (empty($product_count)) : ?>
					<div class="vp-dropmod-header empty">
						<div class="row row-mini">
							<div class="col-xs-12 align-center">
								<?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_WISHLIST_EMPTY') ?>
							</div>
						</div>
					</div>
				<?php else : ?>
					<div class="vp-dropmod-header">
						<div class="row row-mini">
							<div class="col-xs-12">
								<span class="product-count-text"><?php echo JText::sprintf('PLG_SYSTEM_VPFRAMEWORK_WISHLIST_PRODUCT_COUNT', $product_count); ?></span>
								<?php if (!empty($url)) : ?>
									<a class="btn btn-sm btn-base pull-right" href="<?php echo $url ?>" title="<?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_WISHLIST_SHOW') ?>"><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_WISHLIST_SHOW') ?></a>
								<?php endif; ?>
							</div>
						</div>
					</div>
					<?php foreach ($products as $key => $product) : ?>
						<div class="row row-mini product-row">
							<div class="col-xs-3">
								<a href="<?php echo $product->link ?>" class="product-thumbnail">
									<?php echo !empty($product->images[0]) ? $product->images[0]->displayMediaThumb('', false) : ''; ?>
								</a>
							</div>
							<div class="col-xs-8">
								<?php echo JHtml::link ($product->link, $product->product_name, 'class="mod-product-name hover-invert"'); ?>
								<?php if ($params->get('show_price', 1) && $currencyDisplay->_priceConfig['salesPrice'][0]) : ?>
								<div class="mod-product-price">
									<?php echo $currencyDisplay->priceDisplay($product->prices['salesPrice']); ?>
								</div>
								<?php endif; ?>
							</div>
							<div class="col-xs-1">
								<button type="button" class="close remove vpf-removefromwishlist-btn" data-productid="<?php echo $product->virtuemart_product_id ?>" data-productname="<?php echo $product->product_name ?>" title="<?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_REMOVE') ?>" data-ajax="<?php echo (int) $ajax ?>">
									<span aria-hidden="true">&times;</span><span class="sr-only"><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_REMOVE') ?></span>
								</button>
							</div>
						</div>
						<?php if (($key + 1) != $product_count) : ?>
							<div class="mod-row-separator"></div>
						<?php endif; ?>
					<?php endforeach; ?>
				<?php endif; ?>
				<div class="vp-dropmod-loader hide"><div class="inner"></div></div>
			</div>
		</div>
	</div>
	<?php echo vmJsApi::writeJS(); ?>
</div>