<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('JPATH_PLATFORM') or die;

JFormHelper::loadFieldClass('list');

class JFormFieldBootstrapGrid extends JFormFieldList
{

	public $type = 'BootstrapGrid';
	
	protected static $calculateFunction = false;
	
	public function getOptions()
	{
		$showperrow = (int) isset($this->element['showperrow']) ? $this->element['showperrow'] : 0;
		
		$options = array();
		
		if ($showperrow)
		{
			$options[] = JHTML::_('select.option', 1, 1);
			$options[] = JHTML::_('select.option', 2, 2);
			$options[] = JHTML::_('select.option', 3, 3);
			$options[] = JHTML::_('select.option', 4, 4);
			$options[] = JHTML::_('select.option', 6, 6);
			$options[] = JHTML::_('select.option', 12, 12);
		}
		else
		{
			for($i = 0; $i <= 12; $i++)
			{
				if ($i == 0)
				{
					$options[] = JHTML::_('select.option', $i, 'Hidden');
				}
				elseif ($i == 12)
				{
					$options[] = JHTML::_('select.option', $i, 'Full Width');
				}
				else
				{
					$options[] = JHTML::_('select.option', $i, $i);
				}
				
			}
		}
		
		return array_merge(parent::getOptions(), $options);
	}
	
	public function getInput()
	{
		$readonly = isset($this->element['readonly']) ? $this->element['readonly'] : false;
		$bootcalculate = isset($this->element['bootcalculate']) ? $this->element['bootcalculate'] : '';
		
		if ($readonly && !empty($bootcalculate))
		{
			JHtml::_('jquery.framework');
			$doc = JFactory::getDocument();
			$doc->addScriptDeclaration("
			jQuery(document).ready(function($) {
				$('" . $bootcalculate . "').each(function() {
					var balance = getBalanceBootGrid('" . $bootcalculate . "');
					if (balance == 12) {
						$('#" . $this->id . "').val('Full Width');
					} else if (balance > 0) {
						$('#" . $this->id . "').val(balance);
					} else {
						$('#" . $this->id . "').val('Hidden');
						$('" . $bootcalculate . "').not(this).val(12 - parseInt(jQuery(this).val())).trigger('liszt:updated');
					}
				});
				$('" . $bootcalculate . "').change(function() {
					var balance = getBalanceBootGrid('" . $bootcalculate . "');
					if (balance == 12) {
						$('#" . $this->id . "').val('Full Width');
					} else if (balance > 0) {
						$('#" . $this->id . "').val(balance);
					} else {
						$('#" . $this->id . "').val('Hidden');
						$('" . $bootcalculate . "').not(this).val(12 - parseInt(jQuery(this).val())).trigger('liszt:updated');
					}
				});
			});
			");
			
			if (!static::$calculateFunction)
			{
				$doc->addScriptDeclaration("
				function getBalanceBootGrid(el) {
					var total = 0;
					jQuery(el).each(function(){
						total += parseInt(jQuery(this).val());
					});
					
					return (12 - total);
				}
				");
				static::$calculateFunction = true;
			}
			
			$html = '<input type="text" name="' . $this->name . '" id="' . $this->id . '" value="' . (int) $this->value . '" readonly="readonly" class="form-control" />';
			
			return $html;
		}
		else
		{
			return parent::getInput();
		}
	}
}
