<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

class JFormFieldDlks extends JFormField
{
	protected $type = 'Dlks';
	
	function getInput()
	{
		$html        = array();
		$this->value = is_array($this->value) ? $this->value : array();
		$name        = str_replace('[]', '', $this->name);
		
		foreach ($this->value as $key => $value)
		{
			$html[] = '<input type="hidden" name="' . $name . '[' . $key . ']" value="' . $value . '" />';
		}
		
		$html = count($html) ? implode("\n", $html) : '';
		
		return $html;
	}
	
	function getLabel()
	{
		return '';
	}
}