<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JFormHelper::loadFieldClass('list');

class JFormFieldGFontVariants extends JFormFieldList
{
	protected $type = 'GFontVariants';

	protected function getOptions()
	{
		$options = parent::getOptions();
		$parent  = !empty($this->element['parent']) ? (string) $this->element['parent'] : null;
		$form    = new JRegistry($this->form->getValue('params'));
		
		if (empty($parent))
		{
			return $options;
		}
		
		JHtml::_('jquery.framework');
		
		$doc = JFactory::getDocument();
		$token = JSession::getFormToken();
		$doc->addScriptDeclaration("
			jQuery(document).ready(function($) {
				$('.{$parent}').on('change', function() {
					var form = $(this).parents('form');
					var url = form.attr('action');
					var font_name = $(this).val();
					$('#{$this->id}').html('');
					$.ajax({
						type: 'GET',
						dataType: 'JSON',
						url: url,
						data: {
							'task': 'style.getGoogleFont',
							'font_name': encodeURIComponent(font_name),
							'{$token}': 1
						},
						success: function(e) {
							if (e.error) {
								VPFramework.showMessage(e.msg, 'red');
							}
							if (e.redirect) {
								window.location.replace(e.redirect);
							} else if (e.reload) {
								window.location.reload();
							}
							if (!e.msg.variants) {
								$('#{$this->id}').trigger('liszt:updated');
								return false;
							}
							var options = '';
							$.each(e.msg.variants, function(index, value) {
								options += '<option value=\"' + value + '\">' + $.trim($.ucwords(value.replace(/([a-z])/, \" $1\"))) + '</option>';
							});
							$('#{$this->id}').html(options);
							$('#{$this->id}').trigger('liszt:updated');
						},
						error: function(e, f, g) {
							console.log(e);
							console.log(f);
							console.log(g);
							$('#{$this->id}').trigger('liszt:updated');
						}
					});
					
				});
			})
		");
		
		$helper = VPFrameworkAdmin::getInstance();
		$selectedFont = $form->get($parent, '');
		
		if (empty($selectedFont))
		{
			$fonts = $helper->getGoogleFonts(false);
			
			if (empty($fonts))
			{
				return $options;
			}
			
			$selectedFont = $fonts[0]['family'];
		}
		
		$font = $helper->getGoogleFont($selectedFont, false);
		
		if (empty($font))
		{
			return $options;
		}
		
		$items = !empty($font['variants']) ? $font['variants'] : array();
		
		foreach ($items as $item)
		{
			$Ints = preg_match_all('/[0-9]/', $item, $imatch);
			$name = $Ints > 0 ? preg_replace('/([a-z])/', ' $0', $item, 1) : $item;
			$options[] = JHtml::_('select.option', $item, ucwords($name));
		}
		
		return $options;
	}
}