<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die();

jimport( 'joomla.registry.registry' );

JFormHelper::loadFieldClass('multilist');

class JFormFieldVMCustomfields extends JFormFieldMultilist
{
	protected $type = 'VMCustomfields';
	
	protected static $customfields = array();

	protected function getOptions()
	{
		$field_type        = !empty($this->element['field_type']) ? (string) $this->element['field_type'] : null;
		$is_cart_attribute = !empty($this->element['is_cart_attribute']) ? (int) $this->element['is_cart_attribute'] : null;
		$is_input          = !empty($this->element['is_input']) ? (int) $this->element['is_input'] : null;
		$layout_pos        = !empty($this->element['layout_pos']) ? (string) $this->element['layout_pos'] : null;
		$published         = !empty($this->element['published']) ? (int) $this->element['published'] : 1;
		$hash              = md5('field_type:' . $field_type . '.is_cart_attribute:' . $is_cart_attribute . '.is_input:' . $is_input . '.layout_pos:' . $layout_pos . '.published:' . $published);

		if (!isset(static::$customfields[$hash]))
		{
			$db    = JFactory::getDbo();
			$query = $db->getQuery(true)
				->select('custom_title AS text, virtuemart_custom_id AS value, field_type, custom_params')
				->from('#__virtuemart_customs');

			if (!empty($field_type))
			{
				if (strpos($field_type, ',') !== false)
				{
					$field_type = explode(',', $field_type);
				}
				else
				{
					$field_type = array($field_type);
				}
				
				$field_type = array_filter(array_map('trim', $field_type));
				
				if (!empty($field_type))
				{
					if (count($field_type) === 1)
					{
						$query->where('field_type = ' . $db->quote($field_type[0]));
					}
					else
					{
						$query->where('field_type IN (' . implode(',', $db->quote($field_type)) . ')');
					}
				}
			}
			
			if (!empty($is_cart_attribute))
			{
				$query->where('is_cart_attribute = ' . $is_cart_attribute);
			}
			
			if (!empty($is_input))
			{
				$query->where('is_input = ' . $is_input);
			}

			if (!empty($layout_pos))
			{
				$query->where('layout_pos = ' . $db->quote($layout_pos));
			}
			
			if (!empty($published))
			{
				$query->where('published = ' . $published);
			}
			
			try
			{
				$db->setQuery($query);
				$items = $db->loadObjectList();
			}
			catch(Exception $e)
			{
				JFactory::getApplication()->enqueueMessage($e->getMessage(), 'error');
				return false;
			}
			
			if (empty($items))
			{
				static::$customfields[$hash] = array();
			}
			else
			{
				static::$customfields[$hash] = $items;
			}
		}

		$options = array();
		
		if (!empty(static::$customfields[$hash])) 
		{
				foreach (static::$customfields[$hash] as $item) 
				{
					if ($item->field_type == 'C')
					{
						$params = $this->decodeParams($item->custom_params);
						
						if (!$params->get('selectType', 0))
						{
							continue;
						}
					}
					
					$options[] = JHTML::_('select.option', $item->value, JText::_($item->text));
				}
		}
		
		$options = array_merge(parent::getOptions(), $options);

		return $options;
	}
	
	private function decodeParams($string)
	{
		$params = new JRegistry;
		
		if (empty($string))
		{
			return $params;
		}
		
		$parts = strpos($string, '|') !== false ? explode('|', $string) : array($string);
		$array = array();
		
		foreach ($parts as $part)
		{
			if (strpos($part, '=') !== false)
			{
				$part = explode('=', $part);
				$array[$part[0]] = @json_decode($part[1]);
			}
		}
		
		$params->loadArray($array);
		
		return $params;
	}
}