<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

class JFormFieldVPSitePreview extends JFormField
{
	protected $type = 'VPSitePreview';
	
	function getInput()
	{
		JHtml::_('jquery.framework');
		$doc = JFactory::getDocument();
		
		$doc->addScriptDeclaration("
		jQuery(document).ready(function($) {
			$('#{$this->id}-lbl').parent('.control-label').siblings('.controls').css('margin', 0);
			$('#{$this->id}-lbl').parent('.control-label').remove();
			if ($('#vp-preview-wrap').hasClass('scale-to-fit')) {
				previewFitToScreen();
			} else {
				previewNormal();
			}
			$('input[name=\"prev_scale_to_fit\"]:radio').on('click', function() {
				var value = $('input[name=\"prev_scale_to_fit\"]:radio:checked').val();
				if (value == 1) {
					$('#vp-preview-wrap').addClass('scale-to-fit');
					previewFitToScreen();
				} else {
					$('#vp-preview-wrap').removeClass('scale-to-fit');
					previewNormal();
				}
			});
			var prevResize;
			$(window).resize(function(){
				if (!$('#vpf-params-style').hasClass('selected')) {
					return false;
				}
				if (prevResize) {
					clearTimeout(prevResize);
				}
				prevResize = setTimeout(function() {
					if ($('#vp-preview-wrap').hasClass('scale-to-fit')) {
						previewFitToScreen();
					} else {
						previewNormal();
					}
				}, 200);
			});
			$(window).on('load', function() {
				$('#vp-preview-wrap .loading').removeClass('hide');
				$('#vp-site-preview').attr('src', $('#vp-site-preview').data('src'));
				previewFitToScreen();
			});
		});
		function previewFitToScreen() {
			var $ = jQuery.noConflict();
			if ($('#vp-preview-wrap').parents('.span6').length) {
				var width = $('#vp-preview-wrap').parents('.span6').width();
			} else {
				var width = $('#vp-preview-wrap').closest('.controls').width();
			}
			$('#vp-preview-wrap').removeAttr('style').width(width).css({'overflow': 'hidden', 'margin-left': -10, 'margin-right': -10});
			var scale = (width / 1230).toFixed(2);
			$('#vp-site-preview').removeAttr('style').css({
				'width' : 1230, 
				'min-width' : 1230,
				'-ms-zoom' : scale,
				'-moz-transform' : 'scale(' + scale + ')',
				'-moz-transform-origin' : '0 0',
				'-o-transform' : 'scale(' + scale + ')',
				'-o-transform-origin' : '0 0',
				'-webkit-transform' : 'scale(' + scale + ')',
				'-webkit-transform-origin' : '0 0'
				});
		}
		function previewNormal() {
			var $ = jQuery.noConflict();
			if ($('#vp-preview-wrap').parents('.span6').length) {
				var width = $('#vp-preview-wrap').parents('.span6').width();
			} else {
				var width = $('#vp-preview-wrap').closest('.controls').width();
			}
			$('#vp-preview-wrap').removeAttr('style').width(width).css({'overflow': '', 'height' : 'auto', 'padding': 0});
			$('#vp-site-preview').removeAttr('style').css({'width': '100%', 'min-width' : 0, 'height': 500});
		}
		function refreshPreview() {
			var $ = jQuery.noConflict();
			$('#vp-preview-wrap .loading').removeClass('hide');
			$('#vp-site-preview')[0].contentDocument.location.reload(true);
			if ($('#vp-preview-wrap').hasClass('scale-to-fit')) {
				previewFitToScreen();
			} else {
				previewNormal();
			}
		}
		function removePrevLoader() {
			var $ = jQuery.noConflict();
			$('#vp-preview-wrap .loading').addClass('hide');
		}
		");
		$doc->addStyleDeclaration("
		#{$this->id}-lbl {
			display: none;
		}
		#prev_scale_to_fit_lbl {
			display: inline-block;
			margin-right: 15px;
		}
		.preview-toolbar {
			margin-bottom: 15px;
		}
		");
		
		$html  = '';
		
		$html .= '<div class="preview-toolbar clearfix">';
		$html .= '<label for="prev_scale_to_fit" id="prev_scale_to_fit_lbl">Scale to Fit</label>';
		
		if (version_compare(JVERSION, '4.0.0', 'ge'))
		{
			$html .= '<fieldset id="prev_scale_to_fit" class="radio btn-group btn-group-yesno" >';
			$html .= '<input type="radio" id="prev_scale_to_fit0" name="prev_scale_to_fit" value="1" checked="checked" class="btn-check" />';
			$html .= '<label for="prev_scale_to_fit0" class="btn btn-outline-success">Yes</label>';
			$html .= '<input type="radio" id="prev_scale_to_fit1" name="prev_scale_to_fit" value="0" class="btn-check" />';
			$html .= '<label for="prev_scale_to_fit1" class="btn btn-outline-danger">No</label>';
			$html .= '</fieldset>';
		}
		else
		{
			$html .= '<fieldset id="prev_scale_to_fit" class="radio btn-group btn-group-yesno" >';
			$html .= '<input type="radio" id="prev_scale_to_fit0" name="prev_scale_to_fit" value="1" checked="checked" />';
			$html .= '<label for="prev_scale_to_fit0" >Yes</label>';
			$html .= '<input type="radio" id="prev_scale_to_fit1" name="prev_scale_to_fit" value="0" />';
			$html .= '<label for="prev_scale_to_fit1" >No</label>';
			$html .= '</fieldset>';
		}
		
		$html .= '<button type="button" class="btn btn-outline-secondary pull-right float-end" onclick="refreshPreview();"><i class="aicon-loop3 aicon-align-middle"></i>&nbsp;&nbsp;Refresh</button>';
		$html .= '</div>';
		
		$html .= '<div id="vp-preview-wrap" class="scale-to-fit">';
		$html .= '<iframe id="vp-site-preview" src="about:blank" data-src="' . JUri::root() . '" width="100%" border="0" onload="parent.removePrevLoader();"></iframe>';
		$html .= '<div class="loading"></div>';
		$html .= '</div>';
		
		return $html;
	}
	
}