<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

class VPFrameworkCompressorCss extends VPFrameworkCompressor
{
	protected $css   = '';
	protected $o_css = '';
	protected $uri   = '(?<=url)\([^)]*+\)';
	
	public function proccess($css)
	{
		$this->css   = $css;
		$this->o_css = $this->css;
		
		try
		{
			return $this->compress();
		}
		catch (Exception $e) 
		{
			return $this->o_css;
		}
	}
	
	protected function compress()
	{
		$uri          = $this->uri;
		$double_quote = $this->double_quote;
		$single_quote = $this->single_quote;
		
		$es = $double_quote . '|' . $single_quote;
		$s  = '(?<!\\\\)(?:' . $es . ')|[\'"]';
		$e  = '(?<!\\\\)(?:' . $es . '|' . $uri . ')|[\'"(]';

		// Remove all comments
		$regex = "#(?>/?[^/\"'(]*+(?:$e)?)*?\K(?>/\*(?:\*?[^*]*+)*?\*/|//[^\r\n]*+|$)#s";

		$this->css = $this->replace($regex, '', $this->css, '1');

		// Remove ws around , ; : { } in CSS Declarations and media queries
		$regex = "#(?>(?:[{};]|^)[^{}@;]*+{|(?:(?<![,;:{}])\s++(?![,;:{}]))?[^\s{};\"'(]*+(?:$e|[{};])?)+?\K" .
		         "(?:\s++(?=[,;:{}])|(?<=[,;:{}])\s++|\K$)#s";

		$this->css = $this->replace($regex, '', $this->css, '2');

		// Remove ws around , + > ~ { } in selectors
		$regex = "#(?>(?:(?<![,+>~{}])\s++(?![,+>~{}]))?[^\s{\"'(]*+(?:{[^{}]++}|{|$e)?)*?\K" .
		         "(?:\s++(?=[,+>~{}])|(?<=[,+>~{};])\s++|$\K)#s";

		$this->css = $this->replace($regex, '', $this->css, '3');

		// Remove last ; in block
		$regex = "#(?>(?:;(?!}))?[^;\"'(]*+(?:$e)?)*?\K(?:;(?=})|$\K)#s";

		$this->css = $this->replace($regex, '', $this->css, '4');

		// Remove ws inside urls
		$regex = "#(?>\(?[^\"'(]*+(?:$s)?)*?(?:(?<=\burl)\(\K\s++|\G" .
		         "(?(?=[\"'])['\"][^'\"]++['\"]|[^\s]++)\K\s++(?=\))|$\K)#s";

		$this->css = $this->replace($regex, '', $this->css, '5');

		// Minimize hex colors
		$regex = "/(?>\#?[^\#\"'(]*+(?:$e)?)*?(?:(?<!=)\#\K" .
		         "([a-f\d])\g{1}([a-f\d])\g{2}([a-f\d])\g{3}(?=[\s;}])|$\K)/is";

		$this->css = $this->replace($regex, '$1$2$3', $this->css, '6');

		// Reduce remaining ws to single space
		$regex = "#(?>[^\s'\"(]*+(?:$e|\s(?!\s))?)*?\K(?:\s\s++|$)#s";

		$this->css = $this->replace($regex, ' ', $this->css, '7');
		
		return trim($this->css);
	}
}