<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

class VPFrameworkModule
{
	static $modules = array();
	
	public static function get($module_id, $params = null)
	{
		$module_id = intval($module_id);
		
		if (!isset($modules[$module_id]))
		{
			$db   = JFactory::getDbo();
			$user = JFactory::getUser();
			
			$query = $db->getQuery(true)
			            ->select('m.id, m.title, m.module, m.position, m.content, m.showtitle, m.params')
			            ->from('#__modules AS m')
			            ->where('m.id = ' . $module_id)
			            ->where('m.published = 1')
			            ->where('m.access IN (' . implode(',', $user->getAuthorisedViewLevels()) . ')');

			$db->setQuery($query);
			$module = $db->loadObject();
			
			if (!empty($module))
			{
				$modules[$module_id] = $module;
			}
			else
			{
				$modules[$module_id] = null;
			}
		}
		
		if (empty($modules[$module_id]) || !isset($modules[$module_id]->id) || empty($modules[$module_id]->id))
		{
			return null;
		}
		
		return $modules[$module_id];
	}
	
	public static function getPosition($position)
	{
		return JModuleHelper::getModules($position);
	}
}