<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VirtuePlanet Framework for Joomla!
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

/**
* VP Framework Script
* 
* @since 1.3.0
*/
abstract class VPFrameworkScript
{
	public static $options = array();
	
	public static $scripts = array();
	
	public static $declarations = array();
	
	public static function addOption($name, $value)
	{
		$name = strtoupper($name);
		self::$options[$name] = $value;
	}
	
	public static function loadOptions()
	{
		if (empty(self::$options))
		{
			return;
		}
		
		$doc = JFactory::getDocument();
		$tab = $doc->_getTab();
		$lineEnd = $doc->_getLineEnd();
		$options = (!empty(self::$options) && is_array(self::$options)) ? json_encode(self::$options) : null;
		
		if (!empty($options))
		{
			$script = $lineEnd . $tab . $tab . '<script type="application/json" class="vpf-script-options new">' . $options . '</script>' . $lineEnd;
			
			$doc->addCustomTag($script);
		}

		// Reset the list after load.
		self::$options = array();
	}
	
	public static function cleanClass($class)
	{
		if (!empty($class) && strpos($class, ' ') !== false)
		{
			$oClass = $class;
			$parts = explode(' ', $class);
			$class = !empty($parts[0]) ? $parts[0] : $parts[1];
			$class = !empty($class) ? str_replace(' ', '', $class) : $oClass;
		}
		
		return $class;
	}
	
	public static function addScript($url, $version = null, $defer = false, $async = false)
	{
		$attributes = array(
		  'version' => $version,
		  'defer' => $defer,
		  'async' => $async
		);
		
		self::$scripts[$url] = $attributes;
	}
	
	public static function addScriptDeclaration($content, $type = 'text/javascript', $unique_id = null, $on_ready = false, $replace = true)
	{
		$data = array(
		  'content' => $content,
		  'type' => $type,
		  'unique_id' => $unique_id,
		  'on_ready' => $on_ready
		);
		
		if (!isset(self::$declarations[$type]))
		{
			self::$declarations[$type] = array();
		}
		
		if (!empty($unique_id) && is_string($unique_id))
		{
			if (!empty(self::$declarations[$type][$unique_id]))
			{
				if (!$replace)
				{
					$doc     = JFactory::getDocument();
					$tab     = $doc->_getTab();
					$lineEnd = $doc->_getLineEnd();
					
					$existing_content = self::$declarations[$type][$unique_id]['content'];
					$data['content'] = $existing_content . $lineEnd . $tab . $tab . $tab . $data['content'];
				}
			}

			self::$declarations[$type][$unique_id] = $data;
		}
		else
		{
			self::$declarations[$type][] = $data;
		}
	}
	
	public static function getScripts()
	{
		$doc          = JFactory::getDocument();
		$tab          = $doc->_getTab();
		$lineEnd      = $doc->_getLineEnd();
		$scripts      = array();
		$declarations = array();
		
		if (!empty(self::$scripts))
		{
			foreach (self::$scripts as $url => $attribs)
			{
				if (empty($url)) continue;
				
				if (!empty($attribs['version']))
				{
					$url = $url . '?ver=' . $attribs['version'];
				}
				
				$script = $tab . '<script src="' . $url . '"';
				
				if (!empty($attribs['type']))
				{
					$script .= ' type="' . $attribs['type'] . '"';
				}
				
				if (!empty($attribs['defer']))
				{
					$script .= ' defer';
				}
				
				if (!empty($attribs['async']))
				{
					$script .= ' async';
				}
				
				$script .= '></script>';
				
				$scripts[] = $script;
			}
		}
		
		if (!empty(self::$declarations))
		{
			$jsOptimized = false;
			
			if (class_exists('plgSystemVPFrameworkHelper'))
			{
				$template     = plgSystemVPFrameworkHelper::getTemplate();
				$tmpl_params = $template->params;
				
				if ($tmpl_params->get('optimizer_combine_js') && !$tmpl_params->get('optimizer_exclude_inline_js'))
				{
					$jsOptimized = true;
				}
			}
			
			foreach (self::$declarations as $type => $items)
			{
				$declaration = $tab . '<script';
				
				if (!empty($type))
				{
					$declaration .= ' type="' . $type . '"';
				}
				
				$declaration .= '>' . $lineEnd;
				
				foreach ($items as $item)
				{
					if (empty($item['content'])) continue;
					
					$need_closer = false;
					
					if ($jsOptimized && !empty($item['on_ready']))
					{
						$declaration .= $tab . $tab . 'jQuery(document).ready(function() {' . $lineEnd;
						$need_closer = true;
					}
					
					$declaration .= $tab . $tab . $tab . $item['content'] . $lineEnd;
					
					if ($need_closer)
					{
						$declaration .= $tab . $tab . '})' . $lineEnd;
					}
				}
				
				$declaration .= $tab . '</script>';
				
				$declarations[] = $declaration;
			}
		}
		
		$string = '';
		
		if (!empty($scripts))
		{
			$string .= implode($lineEnd, $scripts);
		}
		
		if (!empty($declarations))
		{
			if (!empty($string))
			{
				$string .= $lineEnd;
			}
			
			$string .= implode($lineEnd, $declarations);
		}
		
		return $string;
	}
}