/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
!(function($) {
	$(function() {
		if ($('.vpf-menu').length) {

			var $menu = $('.vpf-menu'),
				$nav = $menu.parents('.navbar .navbar-collapse'),
				$subExpand = $('.vpf-menu .submenu li.deeper > ul, .mega-sub-cont.mega-menu-expand'),
				$container = $menu.closest('.inner-container'),
				$parent,
				maxWidth = $container.outerWidth(),
				width = null,
				offset = null,
				offsetDiff,
				availableLeft,
				halfWidth,
				top,
				resizeIt = null,
				animation = $menu.data('animate') ? $menu.data('animate') : 'slide',
				easingOpen = $menu.data('easing-open') ? $menu.data('easing-open') : 'linear',
				easingClose = $menu.data('easing-close') ? $menu.data('easing-close') : 'linear',
				easingTime = $menu.data('easing-time') ? $menu.data('easing-time') : 100;

			// VM Category fix
			if ($nav.find('li.vmcategory.level-2.parent').length)
				$nav.find('li.vmcategory.level-2').addClass('mega-group');
			
			function initMegadrop() {
				$subExpand.css({
					'opacity': 1,
					'display': 'block',
					'visibility': 'hidden',
					'left': '',
					'top': '',
					'width': '',
					'min-width': ''
				});

				$subExpand.each(function() {
					width = $(this).data('megamenu-width');
					$parent = $(this).closest('li');
					
					if(!$parent.closest('.mega-sub-cont.mega-menu-expand').length) {
						top = ($container.offset().top + $container.outerHeight() - $parent.offset().top);
					} else {
						top = '';
					}
					
					if (width == 'justify') {
						offset = $(this).parent().offset().left - $container.offset().left;
						$(this).css({
							'width': maxWidth,
							'min-width': maxWidth,
							'left': -offset,
							'top' : top
						});
					} else if (width == 'auto') {
						if ($(this).children('ul.row').length) {
							if ($(this).parent().hasClass('level-1')) {
								width = $container.offset().left + maxWidth - $(this).offset().left;
							} else {
								width = null;
							}
						}
						if (width) {
							$(this).css({
								'width': width,
								'min-width': width,
								'top': top
							});
						}
						offsetDiff = ($(this).offset().left + $(this).outerWidth()) - ($container.offset().left + maxWidth + 1);
						availableLeft = ($(this).offset().left - $container.offset().left) + 2;
						if (offsetDiff > 1) {
							if (offsetDiff < availableLeft) {
								$(this).css('left', ((offsetDiff + 1) * -1));
							} else {
								$(this).addClass('mega-align-right');
							}
						}
					} else {
						if(width > maxWidth) {
							width = maxWidth;
						}
						$(this).css({
							'width': width,
							'min-width': width,
							'top': top
						});
						offsetDiff = ($(this).offset().left + $(this).outerWidth()) - ($container.offset().left + maxWidth + 1);
						availableLeft = ($(this).offset().left - $container.offset().left) + 2;
						if (offsetDiff > 1) {
							if (offsetDiff < availableLeft) {
								$(this).css('left', ((offsetDiff + 1) * -1));
							} else {
								$(this).addClass('mega-align-right');
							}
						} else if(width >= 700) {
							halfWidth = (width - $parent.outerWidth()) / 2;
							if(availableLeft > 0 && (offsetDiff * -1) < availableLeft) {
								$(this).css('left', (offsetDiff + 1));
							} else if(availableLeft > 0 && halfWidth < availableLeft) {
								$(this).css('left', (halfWidth * -1));
							}
							
						}
					}
				});
				
				$subExpand.css({
					'opacity': '',
					'display': '',
					'visibility': ''
				});
			};
			
			initMegadrop();

			function resizedw() {
				// Haven't resized in 500ms!
				maxWidth = $container.outerWidth();
				initMegadrop();
			}

			window.onresize = function() {
				clearTimeout(resizeIt);
				resizeIt = setTimeout(resizedw, 500);
			};

			// Top Level Menu	
			function mega_open() {
				$(this).addClass('open');
				if (animation == 'slide') {
					$(this).children('.mega-sub-cont.mega-menu-expand').slideDown(easingTime, easingOpen);
				} else if (animation == 'fade') {
					$(this).children('.mega-sub-cont.mega-menu-expand').css({
						'opacity': 0,
						'display': 'block'
					}).animate({
						'opacity': 1
					}, easingTime, easingOpen);
				} else {
					$(this).children('.mega-sub-cont.mega-menu-expand').show();
				}
			};

			function mega_close() {
				var $that = $(this);
				$(this).removeClass('open');
				if (animation == 'slide') {
					$(this).children('.mega-sub-cont.mega-menu-expand').slideUp(easingTime, easingClose, function() {
						$that.removeClass('open');
					});
				} else if (animation == 'fade') {
					$(this).children('.mega-sub-cont.mega-menu-expand').animate({
						'opacity': 0
					}, easingTime, easingClose, function() {
						$(this).hide();
						$that.removeClass('open');
					});
				} else {
					$that.removeClass('open');
					$(this).children('.mega-sub-cont.mega-menu-expand').hide();
				}
			};
			var MegaMenuConfig = {
				interval: 50,
				sensitivity: 1,
				over: mega_open,
				timeout: 100,
				out: mega_close
			};
			$('.vpf-menu > li').hoverIntent(MegaMenuConfig);

			// Sub Menu Script
			function sub_open() {
				$(this).addClass('open');
				if (animation == 'slide') {
					$(this).children('.mega-sub-cont.mega-menu-expand, ul').show(easingTime, easingOpen);
				} else if (animation == 'fade') {
					$(this).children('.mega-sub-cont.mega-menu-expand, ul').css({
						'opacity': 0,
						'display': 'block'
					}).animate({
						'opacity': 1
					}, easingTime, easingOpen);
				} else {
					$(this).children('.mega-sub-cont.mega-menu-expand, ul').show();
				}
			};

			function sub_close() {
				var $that = $(this);
				if (animation == 'slide') {
					$(this).children('.mega-sub-cont.mega-menu-expand, ul').hide(easingTime, easingClose, function() {
						$that.removeClass('open');
					});
				} else if (animation == 'fade') {
					$(this).children('.mega-sub-cont.mega-menu-expand, ul').animate({
						'opacity': 0
					}, easingTime, easingClose, function() {
						$(this).hide();
						$that.removeClass('open');
					});
				} else {
					$that.removeClass('open');
					$(this).children('.mega-sub-cont.mega-menu-expand, ul').hide();
				}
			};
			var MegaSubMenuConfig = {
				interval: 50,
				sensitivity: 4,
				over: sub_open,
				timeout: 200,
				out: sub_close
			};
			$('.vpf-menu .submenu li.deeper:not(.mega-group), .vpf-menu .submenu.deeper:not(.mega-group)').hoverIntent(MegaSubMenuConfig);

			// Affix on Scroll
			if ($('#vpf-header').hasClass('affix-on-scroll')) {
				$(document).off('affixMegaMenu');
				$(document).on('affixMegaMenu', function() {
					var $header = $('#vpf-header'),
							padding = $('body').pixels('padding-top'),
							height = $('.header-top', $header).outerHeight();
					if ($(window).scrollTop() >= ($header.offset().top - padding)) {
						$('body').addClass('header-fixed').css('padding-top', height)
						$('.category-view .browse-view').data('offset', 150);
					} else {
						$('body').removeClass('header-fixed').css('padding-top', '');
						$('.category-view .browse-view').data('offset', 10);
					}
				});
				var resizeAffix;
				$(window).resize(function() {
					if (resizeAffix) {
						clearTimeout(resizeAffix);
					}
					resizeAffix = setTimeout(function() {
						$(document).trigger('affixMegaMenu');
					}, 200);
				});
				$(window).scroll(function() {
					$(document).trigger('affixMegaMenu');
				});
				$(document).trigger('affixMegaMenu');
			}
		}
	});

	$.fn.pixels = function(property) {
		return parseInt(this.css(property).slice(0, -2));
	};
})(jQuery);