/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
(function($) {
	$(function() {

		var vpOffcanvas = {};
		vpOffcanvas.windowWidth = $(window).width();
		vpOffcanvas.menu = $('#vpf-offcanvas');
		vpOffcanvas.module = $('#vpf-offcanvas-module');
		vpOffcanvas.module_content = '';

		$(document).off('vpf.offcanvas.load');
		$(document).on('vpf.offcanvas.load', function() {

			if (vpOffcanvas.menu.length) {

				// Set OffCanvas variables
				var slidingSubmenus = vpOffcanvas.menu.data('sliding');
				var classes = vpOffcanvas.menu.data('classes') ? vpOffcanvas.menu.data('classes') : 'mm-slide';
				var position = vpOffcanvas.menu.data('position') ? vpOffcanvas.menu.data('position') : 'left';
				var zposition = vpOffcanvas.menu.data('zposition') ? vpOffcanvas.menu.data('zposition') : 'back';
				var counters = vpOffcanvas.menu.data('counters');
				var header_add = vpOffcanvas.menu.data('header-add');
				var header_title = vpOffcanvas.menu.data('header-title') ? vpOffcanvas.menu.data('header-title') : '';
				var footer_add = vpOffcanvas.module.length ? true : false;
				if (vpOffcanvas.module.length) {
					vpOffcanvas.module.removeClass('hide');
					vpOffcanvas.module_content = vpOffcanvas.module[0];
					vpOffcanvas.module.remove();
				}

				// Initialize Offcanvas menu
				vpOffcanvas.menu.mmenu({
					classes: classes,
					counters: counters,
					slidingSubmenus: slidingSubmenus,
					header: {
						add: header_add,
						update: true,
						title: header_title
					},
					offCanvas: {
						position: position,
						zposition: zposition
					},
					footer: {
						add: footer_add,
						content: vpOffcanvas.module_content
					}
				}).on('opened.mm', function() {
					$(window).trigger('resize');
					vpOffcanvas.windowWidth = $(window).width();
					$('.mm-subopen, .mm-prev', this).on('click', function() {
						setTimeout(function() {
							$(window).trigger('resize');
						}, 400);
					})
				});

				// Wait as mmenu setup completes
				// then setup nano scroller and add close button
				setTimeout(function() {
					vpOffcanvas.menu = $('#vpf-offcanvas');
					vpOffcanvas.menu.children('ul').addClass('nano-content');
					vpOffcanvas.menu.nanoScroller();
					// Check and add close button
					if (!$('.btn-offcanvas-close', vpOffcanvas.menu).length) {
						var $closeButton = $('<button type="button" class="btn btn-offcanvas-close" title="' + Joomla.JText._('JLIB_HTML_BEHAVIOR_CLOSE') + '"><span aria-hidden="true">&times;</span><span class="sr-only">' + Joomla.JText._('JLIB_HTML_BEHAVIOR_CLOSE') + '</span></button>');
						$closeButton.on('click', function() {
							vpOffcanvas.menu.trigger('close.mm');
						});
						vpOffcanvas.menu.prepend($closeButton);
					}
				}, 400);

				// Close OffCanvas if window is resized and window width is increased
				$(window).resize(function(e) {
					var that = this;
					waitForFinalEvent(function() {
						vpOffcanvas.menu = $('#vpf-offcanvas');
						if (vpOffcanvas.menu.hasClass('mm-opened')) {
							if ($(that).width() > vpOffcanvas.windowWidth) {
								vpOffcanvas.menu.trigger('close.mm');
							}
						}
						if (vpOffcanvas.menu.hasClass('mm-hasfooter')) {
							$('.mm-list', vpOffcanvas.menu).css('padding-bottom', $('.mm-footer').height() - 20);
						}
					}, 200, 'off-canvas');
				});
			}
		});

		// Trigger to setup Offcanvas menu
		$(document).trigger('vpf.offcanvas.load');
	});
})(jQuery);