/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
(function($) {
    $(document).ready(function() {

        $(document).off('template.basic.initialize');
        $(document).on('template.basic.initialize', function() {

            $('.hasTooltip').tooltip({
                'html': true,
                'container': 'body'
            });

            // Scroll to top
            $(window).scroll(function() {
                var scroll = $(window).scrollTop();
                if (scroll >= 122) {
                    $('#header .navigation').addClass('sticky');
                } else {
                    $('#header .navigation').removeClass('sticky');
                }
                if ($(this).scrollTop()) {
                    $('[data-scroll="top"]').addClass('active');
                } else {
                    $('[data-scroll="top"]').removeClass('active');
                }
            });
            $('[data-scroll="top"]').off('click');
            $('[data-scroll="top"]').on('click', function(e) {
                e.preventDefault();
                $('html, body').animate({
                    scrollTop: 0
                }, 500);
                return false;
            });

        });

        $(document).trigger('template.basic.initialize');
    });

})(jQuery);