<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

$class_suffix    = $this->params->get('cookieconsent_position', 'bottom-right') . ' ' . $this->params->get('cookieconsent_theme', 'light');
$animation       = $this->params->get('cookieconsent_position') == 'top' ? 'slideInDown animated' : 'slideInUp animated';
$close_animation = $this->params->get('cookieconsent_position') == 'top' ? 'slideOutUp animated' : 'slideOutDown animated';
?>
<div class="vp-cookie-consent <?php echo htmlspecialchars($class_suffix); ?>">
	<div class="vp-cookie-consent-inner reveal-later" data-vpcc-anim="<?php echo $animation ?>" data-vpcc-closeanim="<?php echo $close_animation ?>">
		<div class="vp-cookie-consent-content">
			<?php if($this->countModules('cookie-consent')) : ?>
				<div class="vp-cookie-consent-module"><jdoc:include type="modules" name="cookie-consent" style="raw" /></div>
			<?php else : ?>
				<p><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_COOKIE_CONSENT_MESSAGE') ?></p>
			<?php endif; ?>
			<div class="vp-cookie-consent-button">
				<button type="button" class="btn btn-base" data-vpcc-btn="dismiss"><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_COOKIE_CONSENT_BUTTON_LABEL') ?></button>
			</div>
		</div>
	</div>
</div>