<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

JHtml::_('behavior.keepalive');
JHtml::_('behavior.formvalidator');

$template = plgSystemVPFrameworkHelper::getTemplate();

if (isset($this->error)) : ?>
	<div class="contact-error">
		<?php echo $this->error; ?>
	</div>
<?php endif; ?>

<div class="contact-form">
	<form id="contact-form" action="<?php echo JRoute::_('index.php'); ?>" method="post" class="form-validate old-form">
		<fieldset>
			<legend><?php echo JText::_('COM_CONTACT_FORM_LABEL'); ?></legend>
			<div class="form-group">
				<?php echo $template->addHTMLClass($this->form->getLabel('contact_name'), 'label', 'control-label'); ?>
				<?php echo $this->form->getInput('contact_name'); ?>
			</div>
			<div class="form-group">
				<?php echo $template->addHTMLClass($this->form->getLabel('contact_email'), 'label', 'control-label'); ?>
				<?php echo $this->form->getInput('contact_email'); ?>
			</div>
			<div class="form-group">
				<?php echo $template->addHTMLClass($this->form->getLabel('contact_subject'), 'label', 'control-label'); ?>
				<?php echo $this->form->getInput('contact_subject'); ?>
			</div>
			<div class="form-group">
				<?php echo $template->addHTMLClass($this->form->getLabel('contact_message'), 'label', 'control-label'); ?>
				<?php echo $this->form->getInput('contact_message'); ?>
			</div>
			<?php if ($this->params->get('show_email_copy')) : ?>
				<div class="form-group">
					<div class="checkbox">
						<label>
							<?php echo $this->form->getInput('contact_email_copy'); ?> <?php echo trim(strip_tags($this->form->getLabel('contact_email_copy'))); ?>
						</label>
					</div>
				</div>
			<?php endif; ?>
			<?php // Dynamically load any additional fields from plugins. ?>
			<?php foreach ($this->form->getFieldsets() as $fieldset) : ?>
				<?php if ($fieldset->name != 'contact') : ?>
					<?php $fields = $this->form->getFieldset($fieldset->name); ?>
					<?php foreach ($fields as $field) : ?>
						<?php if ($field->hidden):// If the field is hidden, just display the input.?>
							<?php echo $field->input;?>
						<?php else:?>
							<?php VPFrameworkGlobal::getInstance()->setState('form.renderfields.format', array('fieldClass' => '', 'labelClass' => 'control-label')); ?>
							<?php echo $field->renderField(); ?>
						<?php endif;?>
					<?php endforeach; ?>
				<?php endif; ?>
			<?php endforeach; ?>
			<div class="form-group">
				<button class="btn btn-base btn-lg validate" type="submit"><?php echo JText::_('COM_CONTACT_CONTACT_SEND'); ?></button>
			</div>
		</fieldset>
		<input type="hidden" name="option" value="com_contact" />
		<input type="hidden" name="task" value="contact.submit" />
		<input type="hidden" name="return" value="<?php echo $this->return_page; ?>" />
		<input type="hidden" name="id" value="<?php echo $this->contact->slug; ?>" />
		<?php echo JHtml::_('form.token'); ?>
	</form>
</div>
