<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

if (version_compare(JVERSION, '4.0.0', 'ge'))
{
	$this->document->getWebAssetManager()->usePreset('awesomplete');
	$this->document->addScriptOptions('finder-search', array('url' => Route::_('index.php?option=com_finder&task=suggestions.suggest&format=json&tmpl=component')));
}
else
{
	if ($this->params->get('show_advanced', 1) || $this->params->get('show_autosuggest', 1))
	{
		JHtml::_('jquery.framework');

		$script = "
	jQuery(function() {";
		if ($this->params->get('show_advanced', 1))
		{
			/*
			* This segment of code disables select boxes that have no value when the
			* form is submitted so that the URL doesn't get blown up with null values.
			*/
			$script .= "
		jQuery('#finder-search').on('submit', function(e){
			e.stopPropagation();
			// Disable select boxes with no value selected.
			jQuery('#advancedSearch').find('select').each(function(index, el) {
				var el = jQuery(el);
				if(!el.val()){
					el.attr('disabled', 'disabled');
				}
			});
		});";
		}
		/*
		* This segment of code sets up the autocompleter.
		*/
		if ($this->params->get('show_autosuggest', 1))
		{
			JHtml::_('script', 'media/jui/js/jquery.autocomplete.min.js', false, false, false, false, true);

			$script .= "
		var suggest = jQuery('#q').autocomplete({
			serviceUrl: '" . JRoute::_('index.php?option=com_finder&task=suggestions.suggest&format=json&tmpl=component', false) . "',
			paramName: 'q',
			minChars: 1,
			maxHeight: 400,
			width: 300,
			zIndex: 9999,
			deferRequestBy: 500
		});";
		}

		$script .= "
	});";

		JFactory::getDocument()->addScriptDeclaration($script);
	}
}
?>
<?php if (version_compare(JVERSION, '4.0.0', 'ge')) : ?>
	<form action="<?php echo Route::_($this->query->toUri()); ?>" method="get" class="js-finder-searchform">
		<?php echo $this->getFields(); ?>
		<fieldset class="com-finder__search word mb-3">
			<legend class="com-finder__search-legend visually-hidden sr-only">
				<?php echo Text::_('COM_FINDER_SEARCH_FORM_LEGEND'); ?>
			</legend>
			<div class="form-inline">
				<label for="q" class="me-2">
					<?php echo Text::_('COM_FINDER_SEARCH_TERMS'); ?>
				</label>
				<div class="clearfix"></div>
				<div class="form-group">
					<input type="text" name="q" id="q" class="js-finder-search-query form-control" value="<?php echo $this->escape($this->query->input); ?>">
					<button type="submit" class="btn btn-primary">
						<span class="fa fa-search" aria-hidden="true"></span>
						<?php echo Text::_('JSEARCH_FILTER_SUBMIT'); ?>
					</button>
					<?php if ($this->params->get('show_advanced', 1)) : ?>
						<?php HTMLHelper::_('bootstrap.collapse'); ?>
						<button class="btn btn-secondary" type="button" data-bs-toggle="collapse" data-bs-target="#advancedSearch" aria-expanded="<?php echo ($this->params->get('expand_advanced', 0) ? 'true' : 'false'); ?>">
							<span class="fa fa-search-plus" aria-hidden="true"></span>
							<?php echo Text::_('COM_FINDER_ADVANCED_SEARCH_TOGGLE'); ?></button>
					<?php endif; ?>
				</div>
			</div>
		</fieldset>

		<?php if ($this->params->get('show_advanced', 1)) : ?>
			<fieldset id="advancedSearch" class="com-finder__advanced js-finder-advanced collapse<?php if ($this->params->get('expand_advanced', 0)) echo ' show'; ?>">
				<legend class="com-finder__search-advanced visually-hidden">
					<?php echo Text::_('COM_FINDER_SEARCH_ADVANCED_LEGEND'); ?>
				</legend>
				<?php if ($this->params->get('show_advanced_tips', 1)) : ?>
					<div class="com-finder__tips well card card-outline-secondary mb-3">
						<div class="card-body">
							<?php echo Text::_('COM_FINDER_ADVANCED_TIPS_INTRO'); ?>
							<?php echo Text::_('COM_FINDER_ADVANCED_TIPS_AND'); ?>
							<?php echo Text::_('COM_FINDER_ADVANCED_TIPS_NOT'); ?>
							<?php echo Text::_('COM_FINDER_ADVANCED_TIPS_OR'); ?>
							<?php if ($this->params->get('tuplecount', 1) > 1) : ?>
							<?php echo Text::_('COM_FINDER_ADVANCED_TIPS_PHRASE'); ?>
							<?php endif; ?>
							<?php echo Text::_('COM_FINDER_ADVANCED_TIPS_OUTRO'); ?>
						</div>
					</div>
				<?php endif; ?>
				<div id="finder-filter-window" class="com-finder__filter">
					<?php echo HTMLHelper::_('filter.select', $this->query, $this->params); ?>
				</div>
			</fieldset>
		<?php endif; ?>
	</form>
<?php else : ?>
	<form id="finder-search" action="<?php echo JRoute::_($this->query->toURI()); ?>" method="get">
		<?php echo $this->getFields(); ?>

		<?php
		/*
		 * DISABLED UNTIL WEIRD VALUES CAN BE TRACKED DOWN.
		 */
		if (false && $this->state->get('list.ordering') !== 'relevance_dsc') : ?>
			<input type="hidden" name="o" value="<?php echo $this->escape($this->state->get('list.ordering')); ?>" />
		<?php endif; ?>

		<fieldset class="word form-inline">
			<div class="form-group">
				<label for="q" class="sr-only"><?php echo JText::_('COM_FINDER_SEARCH_TERMS'); ?></label>
				<input type="text" name="q" id="q" size="30" value="<?php echo $this->escape($this->query->input); ?>" class="form-control" placeholder="<?php echo JText::_('JSEARCH_FILTER_SUBMIT');?>"/>
			</div>
			<?php if ($this->escape($this->query->input) != '' || $this->params->get('allow_empty_search')):?>
				<button name="Search" type="submit" class="btn btn-default"><span class="icon-search"></span> <?php echo JText::_('JSEARCH_FILTER_SUBMIT');?></button>
			<?php else: ?>
				<button name="Search" type="submit" class="btn btn-default disabled"><span class="icon-search"></span> <?php echo JText::_('JSEARCH_FILTER_SUBMIT');?></button>
			<?php endif; ?>
			<?php if ($this->params->get('show_advanced', 1)) : ?>
				<a href="#advancedSearch" data-toggle="collapse" class="btn btn-default"><span class="icon-list"></span> <?php echo JText::_('COM_FINDER_ADVANCED_SEARCH_TOGGLE'); ?></a>
			<?php endif; ?>
		</fieldset>

		<?php if ($this->params->get('show_advanced', 1)) : ?>
			<div id="advancedSearch" class="collapse<?php if ($this->params->get('expand_advanced', 0)) echo ' in'?>">
				<hr />
				<?php if ($this->params->get('show_advanced_tips', 1)) : ?>
					<div class="advanced-search-tip bg-box bg-info">
						<?php echo JText::_('COM_FINDER_ADVANCED_TIPS'); ?>
					</div>
					<hr />
				<?php endif; ?>
				<?php echo JHtml::_('searchfilter.select', $this->query, $this->params); ?>
			</div>
		<?php endif; ?>
	</form>
<?php endif; ?>
