<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\Component\Finder\Administrator\Indexer\Helper;
use Joomla\Component\Finder\Administrator\Indexer\Taxonomy;
use Joomla\String\StringHelper;
use Joomla\Utilities\ArrayHelper;

// Get the mime type class.
$mime = !empty($this->result->mime) ? 'mime-' . $this->result->mime : null;

$show_description = $this->params->get('show_description', 1);

if ($show_description)
{
	// Calculate number of characters to display around the result
	$term_length = version_compare(JVERSION, '4.0.0', 'ge') ? StringHelper::strlen($this->query->input) : JString::strlen($this->query->input);
	$desc_length = $this->params->get('description_length', 255);
	$pad_length = $term_length < $desc_length ? floor(($desc_length - $term_length) / 2) : 0;

	// Make sure we highlight term both in introtext and fulltext
	$full_description = $this->result->description;

	if (version_compare(JVERSION, '4.0.0', 'ge') && !empty($this->result->summary) && !empty($this->result->body))
	{
		$full_description = Helper::parse($this->result->summary . $this->result->body);
	}

	// Find the position of the search term
	$pos = version_compare(JVERSION, '4.0.0', 'ge') ? StringHelper::strpos(StringHelper::strtolower($full_description), StringHelper::strtolower($this->query->input)) : JString::strpos(JString::strtolower($this->result->description), JString::strtolower($this->query->input));

	// Find a potential start point
	$start = ($pos && $pos > $pad_length) ? $pos - $pad_length : 0;

	// Find a space between $start and $pos, start right after it.
	$space = version_compare(JVERSION, '4.0.0', 'ge') ? StringHelper::strpos($full_description, ' ', $start > 0 ? $start - 1 : 0) : JString::strpos($this->result->description, ' ', $start > 0 ? $start - 1 : 0);
	$start = ($space && $space < $pos) ? $space + 1 : $start;

	$description = JHtml::_('string.truncate', (version_compare(JVERSION, '4.0.0', 'ge') ? StringHelper::substr($full_description, $start) : JString::substr($this->result->description, $start)), $desc_length, true);
}

$route = $this->result->route;

// Get the route with highlighting information.
if (!empty($this->query->highlight)
	&& empty($this->result->mime)
	&& $this->params->get('highlight_terms', 1)
	&& JPluginHelper::isEnabled('system', 'highlight'))
{
	$route .= '&highlight=' . base64_encode(json_encode($this->query->highlight));
}

$showImage = $this->params->get('show_image', 0);

if ($showImage && !empty($this->result->imageUrl))
{
	$imageclass        = $this->params->get('image_class', '');
	$image             = HTMLHelper::cleanImageURL($this->result->imageUrl);
	$extraAttr         = '';

	// Set lazyloading only for images which have width and height attributes
	if ((isset($image->attributes['width']) && (int) $image->attributes['width'] > 0)
		&& (isset($image->attributes['height']) && (int) $image->attributes['height'] > 0))
	{
		$extraAttr = ArrayHelper::toString($image->attributes) . ' loading="lazy"';
	}
}

$icon = '';
if (!empty($this->result->mime)) :
	$icon = '<span class="icon-file-' . $this->result->mime . '" aria-hidden="true"></span> ';
endif;

$show_url = '';
if ($this->params->get('show_url', 1)) :
	$show_url = '<cite class="result__title-url">' . $this->baseUrl . Route::_($this->result->cleanURL) . '</cite>';
endif;
?>
<?php if (version_compare(JVERSION, '4.0.0', 'ge')) : ?>
	<?php $user = Factory::getApplication()->getIdentity(); ?>
	<li class="result__item">
		<?php if (isset($image)) : ?>
			<figure class="<?php echo htmlspecialchars($imageclass, ENT_COMPAT, 'UTF-8'); ?> result__image">
				<?php if ($this->params->get('link_image') && $this->result->route) : ?>
					<a href="<?php echo Route::_($this->result->route); ?>">
						<img src="<?php echo htmlspecialchars($image->url, ENT_COMPAT, 'UTF-8'); ?>"
							 alt="<?php echo htmlspecialchars($this->result->imageAlt, ENT_COMPAT, 'UTF-8'); ?>"
								<?php echo $extraAttr; ?>
						/>
					</a>
				<?php else : ?>
					<img src="<?php echo htmlspecialchars($image->url, ENT_COMPAT, 'UTF-8'); ?>"
						 alt="<?php echo htmlspecialchars($this->result->imageAlt, ENT_COMPAT, 'UTF-8'); ?>"
							<?php echo $extraAttr; ?>
					/>
				<?php endif; ?>
			</figure>
		<?php endif; ?>
		<p class="result__title">
			<?php if ($this->result->route) : ?>
				<?php echo HTMLHelper::link(
						Route::_($this->result->route),
						'<span class="result__title-text">' . $icon . $this->result->title . '</span>' . $show_url,
						[
								'class' => 'result__title-link'
						]
				); ?>
			<?php else : ?>
				<?php echo $this->result->title; ?>
			<?php endif; ?>
		</p>
		<?php if ($show_description && $description !== '') : ?>
			<p class="result__description">
				<?php if ($this->result->start_date && $this->params->get('show_date', 1)) : ?>
					<time class="result__date" datetime="<?php echo HTMLHelper::_('date', $this->result->start_date, 'c'); ?>">
						<?php echo HTMLHelper::_('date', $this->result->start_date, Text::_('DATE_FORMAT_LC3')); ?>
					</time>
				<?php endif; ?>
				<?php echo $description; ?>
			</p>
		<?php endif; ?>
		<?php $taxonomies = $this->result->getTaxonomy(); ?>
		<?php if (count($taxonomies) && $this->params->get('show_taxonomy', 1)) : ?>
			<ul class="result__taxonomy">
				<?php foreach ($taxonomies as $type => $taxonomy) : ?>
					<?php $branch = Taxonomy::getBranch($type); ?>
					<?php if ($branch->state == 1 && in_array($branch->access, $user->getAuthorisedViewLevels())) : ?>
						<?php $taxonomy_text = []; ?>
						<?php foreach ($taxonomy as $node) : ?>
							<?php if ($node->state == 1 && in_array($node->access, $user->getAuthorisedViewLevels())) : ?>
								<?php $taxonomy_text[] = $node->title; ?>
							<?php endif; ?>
						<?php endforeach; ?>
						<?php if (count($taxonomy_text)) : ?>
							<li class="result__taxonomy-item result__taxonomy--<?php echo $type; ?>">
								<span><?php echo $type; ?>:</span> <?php echo implode(',', $taxonomy_text); ?>
							</li>
						<?php endif; ?>
					<?php endif; ?>
				<?php endforeach; ?>
			</ul>
		<?php endif; ?>
	</li>
<?php else : ?>
<li>
	<h4 class="result-title <?php echo $mime; ?>">
		<a href="<?php echo JRoute::_($route); ?>"><?php echo $this->result->title; ?></a>
	</h4>
	<?php if ($show_description) : ?>
		<p class="result-text<?php echo $this->pageclass_sfx; ?>">
			<?php echo $description; ?>
		</p>
	<?php endif; ?>
	<?php if ($this->params->get('show_url', 1)) : ?>
		<div class="small result-url<?php echo $this->pageclass_sfx; ?>">
			<?php echo $this->baseUrl, JRoute::_($this->result->route); ?>
		</div>
	<?php endif; ?>
</li>
<?php endif; ?>
