<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Router\Route;

JHtml::_('behavior.keepalive');
JHtml::_('behavior.formvalidator');
?>
<div class="narrow-container login<?php echo $this->pageclass_sfx ?>">
	<?php if ($this->params->get('show_page_heading')) : ?>
	<div class="page-header">
		<h1>
			<?php echo $this->escape($this->params->get('page_heading')); ?>
		</h1>
	</div>
	<?php endif; ?>

	<?php if (($this->params->get('logindescription_show') == 1 && str_replace(' ', '', $this->params->get('login_description', '')) != '') || $this->params->get('login_image', '') != '') : ?>
	<div class="login-description">
	<?php endif; ?>

		<?php if ($this->params->get('logindescription_show') == 1) : ?>
			<?php echo $this->params->get('login_description'); ?>
		<?php endif; ?>

		<?php if (($this->params->get('login_image') != '')) :?>
			<img src="<?php echo $this->escape($this->params->get('login_image')); ?>" class="login-image" alt="<?php echo JTEXT::_('COM_USER_LOGIN_IMAGE_ALT')?>"/>
		<?php endif; ?>

	<?php if (($this->params->get('logindescription_show') == 1 && str_replace(' ', '', $this->params->get('login_description', '')) != '') || $this->params->get('login_image', '') != '') : ?>
	</div>
	<?php endif; ?>
	<div class="login-page-inner">
		<form action="<?php echo JRoute::_('index.php?option=com_users&task=user.login'); ?>" method="post" class="form-validate old-form" id="com-users-login__form" role="form">
			<?php foreach ($this->form->getFieldset('credentials') as $field) : ?>
				<?php if (!$field->hidden) : ?>
					<div class="form-group">
						<?php
						if(empty($field->hint))
						{
							$field->hint = $field->getAttribute('label');
						}
						
						echo $field->label;
						echo $field->input;
						?>
					</div>
				<?php endif; ?>
			<?php endforeach; ?>
			<?php if ($this->tfa): ?>
				<div class="form-group">
					<?php
					$secretField = $this->form->getField('secretkey');
					
					if(empty($secretField->hint))
					{
						$secretField->hint = $secretField->getAttribute('label');
					}
					
					echo $secretField->label;
					echo $secretField->input;
					?>
				</div>
			<?php endif; ?>
			<?php if (JPluginHelper::isEnabled('system', 'remember')) : ?>
			<div class="form-group">
				<div class="checkbox">
					<label class="checkbox-switch-label" for="remember">
						<input id="remember" type="checkbox" name="remember" class="checkbox-switch" value="yes" />
						<?php echo JText::_('COM_USERS_LOGIN_REMEMBER_ME') ?>
					</label>
				</div>
			</div>
			<?php endif; ?>
			
			<?php if (!empty($this->extraButtons)) : ?>
				<?php foreach ($this->extraButtons as $button):
					$dataAttributeKeys = array_filter(array_keys($button), function ($key) {
						return substr($key, 0, 5) == 'data-';
					});
					?>
					<div class="com-users-login__submit form-group">
						<div class="controls">
							<button type="button"
									class="btn btn-default btn-block mt-2 <?php echo $button['class'] ?? '' ?>"
									<?php foreach ($dataAttributeKeys as $key): ?>
									<?php echo $key ?>="<?php echo $button[$key] ?>"
									<?php endforeach; ?>
									<?php if ($button['onclick']): ?>
									onclick="<?php echo $button['onclick'] ?>"
									<?php endif; ?>
									title="<?php echo JText::_($button['label']) ?>"
									id="<?php echo $button['id'] ?>"
							>
								<?php if (!empty($button['icon'])): ?>
									<span class="<?php echo $button['icon'] ?>"></span>
								<?php elseif (!empty($button['image'])): ?>
									<?php echo HTMLHelper::_('image', $button['image'], Text::_($button['tooltip'] ?? ''), [
										'class' => 'icon',
									], true) ?>
								<?php elseif (!empty($button['svg'])): ?>
									<?php echo $button['svg']; ?>
								<?php endif; ?>
								<?php echo JText::_($button['label']) ?>
							</button>
						</div>
					</div>
				<?php endforeach; ?>
			<?php endif; ?>
			
			<div class="form-group">
				<button type="submit" class="btn btn-base btn-lg validate" title="<?php echo JText::_('JLOGIN'); ?>"><i class="icon-arrow-right3"></i> <?php echo JText::_('JLOGIN'); ?></button>
			</div>
			<div class="form-group">
				<ul class="list-inline">
					<li>
						<a href="<?php echo JRoute::_('index.php?option=com_users&view=reset'); ?>">
						<?php echo JText::_('COM_USERS_LOGIN_RESET'); ?></a>
					</li>
					<li>
						<a href="<?php echo JRoute::_('index.php?option=com_users&view=remind'); ?>">
						<?php echo JText::_('COM_USERS_LOGIN_REMIND'); ?></a>
					</li>
					<?php
					$usersConfig = JComponentHelper::getParams('com_users');
					if ($usersConfig->get('allowUserRegistration')) : ?>
					<li>
						<a href="<?php echo JRoute::_('index.php?option=com_users&view=registration'); ?>">
							<?php echo JText::_('COM_USERS_LOGIN_REGISTER'); ?></a>
					</li>
					<?php endif; ?>
				</ul>
			</div>
			<input type="hidden" name="return" value="<?php echo base64_encode($this->params->get('login_redirect_url', $this->form->getValue('return'))); ?>" />
			<?php echo JHtml::_('form.token'); ?>
		</form>
	</div>
</div>
