<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die('Restricted access');

if(!class_exists('VmHtml'))
{
	require(VMPATH_ADMIN . '/helpers/html.php');
}
$template          = plgSystemVPFrameworkHelper::getTemplate();
$current_id        = !isset($this->cart->lists['current_id']) ? 0 : $this->cart->lists['current_id'];
$shipto_class      = $this->cart->STsameAsBT ? ' hide' : '';
$shipto_edit_class = $this->cart->STsameAsBT ? ' hide' : '';

if (!isset($this->cart->selected_shipto))
{
	$this->cart->selected_shipto = 0;
}
?>
<div class="cart-addresses-cont">
	<div class="row">
		<div class="col-sm-6">
			<div class="cart-address">
				<div class="cart-address-header">
					<?php echo vmText::_('COM_VIRTUEMART_USER_FORM_BILLTO_LBL'); ?>
				</div>
				<div class="cart-address-content">
					<?php
					$cartfieldNames = array();
					foreach($this->userFieldsCart['fields'] as $fields)
					{
						$cartfieldNames[] = $fields['name'];
					}
					foreach($this->cart->BTaddress['fields'] as $item)
					{
						if(in_array($item['name'], $cartfieldNames))
						{
							continue;
						} 
						if (!empty($item['value']))
						{
							if ($item['name'] === 'agreed')
							{
								$item['value'] = ($item['value'] === 0) ? vmText::_ ('COM_VIRTUEMART_USER_FORM_BILLTO_TOS_NO') : vmText::_ ('COM_VIRTUEMART_USER_FORM_BILLTO_TOS_YES');
							}
							?>
							<span class="values field-<?php echo $item['name'] ?>"><?php echo $item['value'] ?></span>
							<?php if ($item['name'] != 'title' && $item['name'] != 'first_name' && $item['name'] != 'middle_name' && $item['name'] != 'zip') : ?>
								<div class="clearfix"></div>
							<?php endif;
						}
					} ?>
					<input type="hidden" name="billto" value="<?php echo $this->cart->lists['billTo']; ?>"/>
				</div>
			</div>
			<a class="btn btn-default bt-edit-link" href="<?php echo JRoute::_('index.php?option=com_virtuemart&view=user&task=editaddresscart&addrtype=BT', $this->useXHTML, $this->useSSL) ?>" rel="nofollow">
				<i class="icon-pencil2" aria-hidden="true"></i> <?php echo vmText::_ ('COM_VIRTUEMART_USER_FORM_EDIT_BILLTO_LBL'); ?>
			</a>
		</div>
		<div class="col-sm-6">
			<div class="cart-address">
				<div class="cart-address-header">
					<?php echo vmText::_('COM_VIRTUEMART_USER_FORM_SHIPTO_LBL'); ?>
				</div>
				<div class="cart-address-content">
					<?php if(!empty($this->cart->user->virtuemart_user_id) && !empty($this->cart->lists['shipTo'])) : ?>
						<?php echo $template->parseRadioList($this->cart->lists['shipTo']); ?>
						<?php $shipto_edit_class = ''; ?>
					<?php else : ?>
						<div class="checkbox">
							<label>
								<?php echo VmHtml::checkbox ('STsameAsBT', $this->cart->STsameAsBT, 1, 0, 'id="STsameAsBTjs"'); ?>
								<?php echo vmText::_('COM_VIRTUEMART_USER_FORM_ST_SAME_AS_BT'); ?>
							</label>
						</div>
					<?php endif; ?>
					<?php if(!empty($this->cart->ST) && !empty($this->cart->STaddress['fields'])) : ?>
						<div id="cart-shipto-address"<?php echo !empty($shipto_class) ? ' class="' . $shipto_class . '"' : ''; ?>>
							<?php foreach($this->cart->STaddress['fields'] as $item)
							{
								if (!empty($item['value']))
								{
									if ($item['name'] == 'shipto_first_name' || $item['name'] == 'shipto_middle_name' || $item['name'] == 'shipto_zip') : ?>
										<span class="values field-<?php echo $item['name'] ?>"><?php echo $item['value'] ?></span>
									<?php else : ?>
										<span class="values field-<?php echo $item['name'] ?>"><?php echo $item['value'] ?></span>
										<div class="clearfix"></div>
									<?php endif;
								}
							} ?>
						</div>
					<?php endif; ?>
				</div>
			</div>
			<a class="btn btn-default<?php echo $shipto_edit_class ?>" href="<?php echo JRoute::_ ('index.php?option=com_virtuemart&view=user&task=editaddresscart&addrtype=ST&virtuemart_user_id[]=' . $current_id . '&virtuemart_userinfo_id=' . $this->cart->selected_shipto, $this->useXHTML, $this->useSSL) ?>" id="cart-shipto-edit-link" rel="nofollow">
				<i class="icon-pencil2" aria-hidden="true"></i> <?php echo vmText::_ ('COM_VIRTUEMART_USER_FORM_ADD_SHIPTO_LBL'); ?>
			</a>
		</div>
	</div>
</div>