<?php 
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die('Restricted access');

JHtml::addIncludePath(VPF_PLUGINPATH . '/html');

$template = plgSystemVPFrameworkHelper::getTemplate();
$params   = $template->params;

foreach($this->product->virtuemart_manufacturer_id as $manufacturer_id)
{
	$thumbnail = null;
	$model = VmModel::getModel('manufacturer');
	$model->setId($manufacturer_id);
	$manufacturer = $model->getManufacturer($manufacturer_id);
	$model->addImages($manufacturer, 1);
	$thumbnail = $manufacturer->images[0]->displayMediaThumb('class="mfg-thumb-image responsive-image"', false);
	if(strpos($thumbnail, VmConfig::get('no_image_found')) !== false || strpos($thumbnail, VmConfig::get('no_image_set')) !== false)
	{
		$thumbnail = null;
	}
	$details_url  = JRoute::_('index.php?option=com_virtuemart&view=manufacturer&virtuemart_manufacturer_id=' . $manufacturer_id, false);
	$products_url = JRoute::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id=0&virtuemart_manufacturer_id=' . $manufacturer_id, false);
	$buttonText   = JText::sprintf('COM_VIRTUEMART_PRODUCT_FROM_MF', $manufacturer->mf_name); 
	?>
	<span itemprop="brand" itemtype="https://schema.org/Brand" itemscope>
		<meta itemprop="name" content="<?php echo $manufacturer->mf_name ?>" />
	</span>
	<meta itemprop="manufacturer" content="<?php echo $manufacturer->mf_name ?>"/>
	<?php if($params->get('vm_show_manufacturer_modal', 1)) : ?>
		<div class="product-details-manufacturer-logo">
			<div class="man-inner">
				<?php if (!empty($thumbnail)) : ?>
					<a href="#vm-mfg-modal-<?php echo $manufacturer_id ?>" class="mfg-modal-link" data-toggle="modal" ><?php echo $thumbnail ?></a>
				<?php else : ?>
					<a href="#vm-mfg-modal-<?php echo $manufacturer_id ?>" class="mfg-modal-link" data-toggle="modal" ><?php echo $manufacturer->mf_name ?></a>	
				<?php endif; ?>
			</div>
		</div>
		<div class="boot-modal fade" id="vm-mfg-modal-<?php echo $manufacturer_id ?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel-<?php echo $manufacturer_id ?>" aria-hidden="true">
			<div class="modal-dialog">
				<div class="modal-content">	
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal">
							<span aria-hidden="true">&times;</span><span class="sr-only"><?php echo JText::_('JLIB_HTML_BEHAVIOR_CLOSE') ?></span>
						</button>
						<h4 class="modal-title"><?php echo $manufacturer->mf_name ?></h4>
					</div>
					<div class="modal-body">
						<div class="row">
							<?php if(!empty($thumbnail)) : ?>
							<div class="col-xs-4">
								<?php echo $thumbnail ?>
							</div>
							<?php endif; ?>
							<div class="<?php echo empty($thumbnail) ? 'col-xs-12' : 'col-xs-8';?>">
								<?php if(!empty($manufacturer->mf_desc)) : ?>
									<div class="mf-desc">
										<?php echo $manufacturer->mf_desc ?>
									</div>
								<?php endif; ?>
								<?php if(!empty($manufacturer->mf_email)) : ?>
									<div class="mf-email">
										<?php echo JHtml::_('vpfemail.cloak', $manufacturer->mf_email, true, $manufacturer->mf_email, false) ?>
									</div>
								<?php endif; ?>
								<?php if(!empty($manufacturer->mf_url)) : ?>
									<div class="mf-url">
										<a href="<?php echo $template->getCleanExternalURL($manufacturer->mf_url) ?>" target="_blank">
											<span><?php echo $manufacturer->mf_url ?></span>
										</a>
									</div>
								<?php endif; ?>
							</div>
						</div>
					</div>
					<div class="modal-footer">
						<a class="btn btn-base" target="_top" href="<?php echo $products_url; ?>"><?php echo $buttonText ?></a>
						<button class="btn btn-default" data-dismiss="modal" aria-hidden="true"><?php echo JText::_('JLIB_HTML_BEHAVIOR_CLOSE') ?></button>
					</div>
				</div>
			</div>
		</div>
	<?php else : ?>
		<div class="product-details-manifacturer-logo">
			<div class="man-inner">
				<?php if (!empty($thumbnail)) : ?>
					<a href="<?php echo $products_url ?>" class="mfg-modal-link"><?php echo $thumbnail ?></a>
				<?php else : ?>
					<a href="<?php echo $products_url ?>" class="mfg-modal-link product-mf-name"><?php echo $manufacturer->mf_name ?></a>
				<?php endif; ?>
			</div>
		</div>
	<?php endif; ?>
	<?php 
} ?>