<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die('Restricted access');

$doc         = JFactory::getDocument();
$app         = JFactory::getApplication();
$template    = plgSystemVPFrameworkHelper::getTemplate();
$params      = $template->params;
$product_url = JRoute::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $this->product->virtuemart_product_id .
                         '&virtuemart_category_id=' . $this->product->virtuemart_category_id);
?>
<div class="productdetails-view vm-productdetails quickview-product">
	<div class="row row-condensed">
		<div class="col-sm-4">
			<?php echo $this->loadTemplate('imagegallery'); ?>
		</div>
		<div class="col-sm-8">
			<div class="product-title-cont">
				<h1 class="product-title">
					<a href="<?php echo $product_url ?>" class="hover-invert" target="_parent"><?php echo $this->product->product_name ?></a>
				</h1>
			</div>
			<?php if(!empty($this->product->event->afterDisplayTitle)) : ?>
				<div class="eventAfterDisplayTitle">
					<?php echo $this->product->event->afterDisplayTitle ?>
				</div>
			<?php endif; ?>
			<div class="product-rating-cont clearfix">
				<?php echo shopFunctionsF::renderVmSubLayout('rating', array('showRating' => $this->showRating, 'product' => $this->product, 'detailsPage' => true)); ?>
			</div>
			<div class="product-price-stock-sku-cont">
				<?php echo shopFunctionsF::renderVmSubLayout('prices', array('product' => $this->product, 'currency' => $this->currency)); ?>
			</div>
			<?php if(!empty($this->product->product_s_desc)) : ?>
			<div class="product-short-desc-cont">
				<?php echo $this->product->product_s_desc ?>
			</div>
			<?php endif; ?>
			<div class="product-addtocart-cont">
				<?php echo shopFunctionsF::renderVmSubLayout('addtocart', array('product' => $this->product)); ?>
			</div>
			<div class="product-action-buttons-cont first-set">
				<?php if($params->get('vm_wishlist', 1)) : ?>
					<button type="button" class="vpf-addtowishlist-btn btn btn-nobg hover-invert" title="<?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_WISHLIST_ADD_TO_LABEL') ?>" data-productname="<?php echo $this->product->product_name ?>" data-productid="<?php echo $this->product->virtuemart_product_id ?>">
						<i class="fa fa-heart-o"></i>&nbsp;<span><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_WISHLIST_ADD_TO_LABEL') ?></span>
					</button>
				<?php endif; ?>
				<?php if($params->get('vm_compare', 1)) : ?>
					<button type="button" class="vpf-addtocompare-btn btn btn-nobg hover-invert" title="<?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_COMPARE_ADD_TO_LABEL') ?>" data-productname="<?php echo $this->product->product_name ?>" data-productid="<?php echo $this->product->virtuemart_product_id ?>">
						<i class="fa fa-copy"></i>&nbsp;<span><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_COMPARE_ADD_TO_LABEL') ?></span>
					</button>
				<?php endif; ?>
			</div>
		</div>
	</div>
	
	<?php if(VmConfig::get('product_navigation', 1)) : ?>
		<div class="product-neighbours">
			<?php if(!empty($this->product->neighbours['previous'][0])) : ?>
				<?php
				$prev_link = JRoute::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $this->product->neighbours['previous'][0]['virtuemart_product_id'] . '&virtuemart_category_id=' . $this->product->virtuemart_category_id, false);
				$prev_product_name = $this->product->neighbours ['previous'][0]['product_name'];
				?>
				<a href="<?php echo $prev_link ?>" class="neighbour-link neighbour-previous pull-left" title="<?php echo $prev_product_name ?>" rel="prev" onclick="parent.quickviewNavigate(this.href); return false;">
					<i class="fa fa-chevron-left"></i><span class="sr-only"><?php echo $prev_product_name ?></span>
				</a>
			<?php endif; ?>
			<?php if(!empty($this->product->neighbours['next'][0])) : ?>
				<?php
				$next_link = JRoute::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $this->product->neighbours['next'][0]['virtuemart_product_id'] . '&virtuemart_category_id=' . $this->product->virtuemart_category_id, false);
				$next_product_name = $this->product->neighbours ['next'][0]['product_name'];
				?>
				<a href="<?php echo $next_link ?>" class="neighbour-link neighbour-next" title="<?php echo $next_product_name ?>" rel="next" onclick="parent.quickviewNavigate(this.href); return false;">
					<i class="fa fa-chevron-right"></i><span class="sr-only"><?php echo $next_product_name ?></span>
				</a>
			<?php endif; ?>
		</div>
	<?php endif; ?>
	
</div>
<?php echo vmJsApi::writeJS(); ?>
<script type="text/javascript">
  Virtuemart.container = jQuery('.productdetails-view');
  Virtuemart.containerSelector = '.productdetails-view';
</script>