<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die('Restricted access');

$categories         = $viewData['categories'];
$categories_per_row = !empty($viewData['categories_per_row'])? $viewData['categories_per_row'] : VmConfig::get('categories_per_row', 3);
$categories_per_row = empty($categories_per_row) ? 3 : $categories_per_row;
$min_per_row        = isset($viewData['min_per_row']) ? $viewData['min_per_row'] : $categories_per_row;
$categories_per_row = ($categories_per_row < $min_per_row) ? $min_per_row : $categories_per_row;
$category_cellwidth = 'col-xs-6 col-sm-6 col-md-' . floor(12/$categories_per_row);

$lg = 0;
$md = 0;
$sm = 0;
$xs = 0;

if(!empty($categories)) : ?>
	<?php $remaining = count($categories); ?>
	<div class="category-list">
		<div class="row">
			<?php foreach($categories as $category) : ?>
				<?php 
				$lg++;
				$md++;
				$sm++;
				$xs++;
				$remaining--;
				?>
				<?php $url = JRoute::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id=' . (int) $category->virtuemart_category_id, false); ?>
				<div class="category-item <?php echo $category_cellwidth ?>">
					<div class="category-item-inner">
						<div class="category-image-cont">
							<a href="<?php echo $url ?>" title="<?php echo $category->category_name ?>">
								<?php echo $category->images[0]->displayMediaThumb('class="responsive-image"', false); ?>
							</a>
						</div>
						<div class="category-name-cont">
							<h4 class="category-name">
								<a href="<?php echo $url ?>" class="hover-invert" title="<?php echo $category->category_name ?>"><?php echo $category->category_name ?></a>
							</h4>
						</div>
					</div>
				</div>
				<?php if($lg == $categories_per_row) : ?>
					<div class="clearfix visible-lg"></div>
					<div class="clearfix visible-md"></div>
					<?php $lg = 0; ?>
					<?php $md = 0; ?>
				<?php elseif(empty($remaining)) : ?>
					<div class="clearfix visible-lg"></div>
					<div class="clearfix visible-md"></div>
				<?php endif; ?>
				<?php if($sm == 2) : ?>
					<div class="clearfix visible-sm"></div>
					<?php $sm = 0; ?>
				<?php elseif(empty($remaining)) : ?>
					<div class="clearfix visible-sm"></div>
				<?php endif; ?>
				<?php if($xs == 2) : ?>
					<div class="clearfix visible-xs"></div>
					<?php $xs = 0; ?>
				<?php elseif(empty($remaining)) : ?>
					<div class="clearfix visible-xs"></div>
				<?php endif; ?>
			<?php endforeach; ?>
		</div>
	</div>
<?php endif; ?>