<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined ('_JEXEC') or die('Restricted access');

$params         = plgSystemVPFrameworkHelper::getTemplate()->params;
$product        = $viewData['product'];
$showDetails    = isset($viewData['showDetails']) ? $viewData['showDetails'] : false;
$currency       = $viewData['currency'];
$priceType      = $params->get('vm_displayed_price_type', 'salesPrice');
$priceType      = isset($product->prices[$priceType]) ? $priceType : 'salesPrice';
$priceDesc      = $priceType == 'unitPrice' ?
                  vmText::sprintf ('COM_VIRTUEMART_PRODUCT_UNITPRICE', vmText::_('COM_VIRTUEMART_UNIT_SYMBOL_' . $product->product_unit)) :
                  '';
$stockhandle    = VmConfig::get('stockhandle_products', false) && property_exists($product, 'product_stockhandle') && $product->product_stockhandle ? $product->product_stockhandle : VmConfig::get('stockhandle', 'none');
$available_date = substr($product->product_available_date, 0, 10);
$current_date   = date("Y-m-d");
$discount       = !empty($product->prices['discountAmount']) ? round($product->prices['discountAmount'], $currency->_priceConfig['salesPrice'][1]) : 0;
$addSchema      = isset($viewData['addSchema']) ? $viewData['addSchema'] : true;
$downDate       = isset($product->prices['product_price_publish_down']) ? new DateTime($product->prices['product_price_publish_down']) : new DateTime();
$downCalcDate   = new DateTime();
?>
<?php if(!$product->product_discontinued || $params->get('vm_handle_discontinued_products', 0) < 2) : ?>
	<div class="product-price" id="productPrice<?php echo $product->virtuemart_product_id ?>"<?php echo $addSchema ? ' itemprop="offers" itemscope itemtype="https://schema.org/Offer"' : ''; ?>>
		<?php if($addSchema) : ?>
			<meta itemprop="price" content="<?php echo number_format(round($product->prices[$priceType], $currency->_priceConfig['salesPrice'][1]), $currency->_priceConfig['salesPrice'][1], '.', ''); ?>"/>
			<meta itemprop="priceCurrency" content="<?php echo $currency->_vendorCurrency_code_3; ?>"/>
			<?php if ($product->product_discontinued) : ?>
				<meta itemprop="availability" content="https://schema.org/Discontinued"/>
			<?php elseif ($stockhandle == 'risetime' && ($product->product_in_stock - $product->product_ordered) < 1) : ?> 
				<meta itemprop="availability" content="https://schema.org/BackOrder"/>
			<?php elseif ($stockhandle != 'none' && ($product->product_in_stock - $product->product_ordered) < 1) : ?> 
				<meta itemprop="availability" content="https://schema.org/OutOfStock"/>
			<?php else : ?>
				<meta itemprop="availability" content="https://schema.org/InStock"/>
			<?php endif; ?>
			<?php if ($available_date != '0000-00-00' && $current_date < $available_date) : ?>
				<meta itemprop="availabilityStarts" content="<?php echo $available_date; ?>"/>
			<?php endif; ?>
			<meta itemprop="url" content="<?php echo JUri::getInstance()->toString(array('scheme', 'host', 'port')) . JRoute::_($product->canonical) ?>"/>
			<?php if($downDate > $downCalcDate) : ?>
				<meta itemprop="priceValidUntil" content="<?php echo $downDate->format('Y-m-d'); ?>"/>
			<?php endif; ?>
			<meta itemprop="itemCondition" content="https://schema.org/NewCondition" />
		<?php endif; ?>
		<?php if($product->prices['salesPrice'] <= 0 && VmConfig::get ('askprice', 1) && isset($product->images[0]) && !$product->images[0]->file_is_downloadable) : ?>
			<?php $url = JRoute::_('index.php?option=com_virtuemart&view=productdetails&task=askquestion&virtuemart_product_id=' . $product->virtuemart_product_id . '&virtuemart_category_id=' . $product->virtuemart_category_id . '&tmpl=component', false); ?>
			<button type="button" class="btn btn-primary btn-md" data-iframe="modal" data-modaltitle="<?php echo vmText::_ ('COM_VIRTUEMART_PRODUCT_ASKPRICE') ?>" title="<?php echo vmText::_ ('COM_VIRTUEMART_PRODUCT_ASKPRICE') ?>" data-url="<?php echo $url ?>">
				<span><?php echo vmText::_ ('COM_VIRTUEMART_PRODUCT_ASKPRICE') ?></span>
			</button>
		<?php else : ?>
			<?php if($priceType != 'basePriceWithTax' && $priceType != 'salesPriceWithDiscount') : ?>
				<?php if(!empty($discount) && VmConfig::get('basePriceWithTax', 0) && !empty($product->prices['basePriceWithTax']) && round($product->prices['basePriceWithTax'], $currency->_priceConfig['salesPrice'][1]) != $product->prices['salesPrice']) : ?>
					<div class="product-price-before-discount">
						<?php echo $currency->createPriceDiv ('basePriceWithTax', '', $product->prices) ?>
					</div>
				<?php elseif(!empty($discount) && VmConfig::get('salesPriceWithDiscount', 0) && !empty($product->prices['salesPriceWithDiscount']) && round($product->prices['salesPriceWithDiscount'], $currency->_priceConfig['salesPrice'][1]) != $product->prices['salesPrice']) : ?>
					<div class="product-price-before-discount">
						<?php echo $currency->createPriceDiv ('salesPriceWithDiscount', '', $product->prices) ?>
					</div>
				<?php endif; ?>
			<?php elseif(!empty($discount) && $priceType == 'basePriceWithTax' && VmConfig::get('salesPriceWithDiscount', 0) && !empty($product->prices['salesPriceWithDiscount']) && round($product->prices['salesPriceWithDiscount'], $currency->_priceConfig['salesPrice'][1]) != $product->prices['salesPrice']) : ?>
				<div class="product-price-before-discount">
					<?php echo $currency->createPriceDiv ('salesPriceWithDiscount', '', $product->prices) ?>
				</div>
			<?php endif; ?>
			<div class="product-sales-price">
				<?php echo $currency->createPriceDiv($priceType, $priceDesc, $product->prices); ?>
			</div>
			<?php
			$infotax = vmConfig::get('vm_prices_info_tax', 0);
			$infodelivery = vmConfig::get('vm_prices_info_delivery', 0);
			if (($infotax || $infodelivery) && !empty($product->prices['salesPrice'])) : ?>
				<div class="vm-prices-info text-muted<?php echo $addSchema ? '' : ' text-small small text-center'; ?>">
					<?php if ($infotax)
					{
						if($product->prices['priceWithoutTax'] == $product->prices['salesPrice'])
						{
							$taxclusive = 'COM_VM_TAX_EXCLUSIVE';
						}
						else
						{
							$taxclusive = 'COM_VM_TAX_INCLUSIVE';
						}
						
						echo vmText::_($taxclusive);
					}
					
					if($infotax && $infodelivery)
					{
						echo vmText::_('COM_VM_PRICES_INFO_DIVIDER');
					}
					
					if($infodelivery)
					{
						echo vmText::_('COM_VM_PRICES_INFO_DELIVERY');
					} ?>
				</div>
			<?php endif; ?>
			<?php if($priceType != 'discountAmount' && VmConfig::get('discountAmount', 0) && !empty($discount)) : ?>
				<div class="product-discount-amount">
					<?php $discount = ($product->prices['discountAmount'] < 0) ? ($product->prices['discountAmount'] * -1) : $product->prices['discountAmount']; ?>
					<span class="text-danger"><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_YOU_SAVE') . ': ' . $currency->createPriceDiv('discountAmount', '', $discount); ?></span>
				</div>
			<?php endif; ?>
			<?php if($showDetails) : ?>
				<div class="product-all-prices text-muted">
					<?php
					echo $currency->createPriceDiv ('basePrice', 'COM_VIRTUEMART_PRODUCT_BASEPRICE', $product->prices);
					echo $currency->createPriceDiv ('basePriceVariant', 'COM_VIRTUEMART_PRODUCT_BASEPRICE_VARIANT', $product->prices);
					echo $currency->createPriceDiv ('variantModification', 'COM_VIRTUEMART_PRODUCT_VARIANT_MOD', $product->prices);
					
					if (round($product->prices['basePriceWithTax'], $currency->_priceConfig['salesPrice'][1]) != round($product->prices['salesPrice'], $currency->_priceConfig['salesPrice'][1]))
					{
						echo '<span class="price-crossed" >' . $currency->createPriceDiv ('basePriceWithTax', 'COM_VIRTUEMART_PRODUCT_BASEPRICE_WITHTAX', $product->prices) . '</span>';
					}
					
					if (round($product->prices['salesPriceWithDiscount'], $currency->_priceConfig['salesPrice'][1]) != round($product->prices['salesPrice'], $currency->_priceConfig['salesPrice'][1]))
					{
						echo $currency->createPriceDiv ('salesPriceWithDiscount', 'COM_VIRTUEMART_PRODUCT_SALESPRICE_WITH_DISCOUNT', $product->prices);
					}

					echo $currency->createPriceDiv ('salesPrice', 'COM_VIRTUEMART_PRODUCT_SALESPRICE', $product->prices);
					echo $currency->createPriceDiv ('salesPriceTt', 'COM_VIRTUEMART_PRODUCT_SALESPRICE_TT', $product->prices);
					
					if($product->prices['discountedPriceWithoutTax'] != $product->prices['priceWithoutTax'])
					{
						echo $currency->createPriceDiv('discountedPriceWithoutTax', 'COM_VIRTUEMART_PRODUCT_SALESPRICE_WITHOUT_TAX', $product->prices);
						echo $currency->createPriceDiv('discountedPriceWithoutTaxTt', 'COM_VIRTUEMART_PRODUCT_SALESPRICE_WITHOUT_TAX_TT', $product->prices);
					}
					else
					{
						echo $currency->createPriceDiv('priceWithoutTax', 'COM_VIRTUEMART_PRODUCT_SALESPRICE_WITHOUT_TAX', $product->prices);
						echo $currency->createPriceDiv('priceWithoutTaxTt', 'COM_VIRTUEMART_PRODUCT_SALESPRICE_WITHOUT_TAX_TT', $product->prices);
					}
					
					echo $currency->createPriceDiv ('discountAmount', 'COM_VIRTUEMART_PRODUCT_DISCOUNT_AMOUNT', $product->prices);
					echo $currency->createPriceDiv ('discountAmountTt', 'COM_VIRTUEMART_PRODUCT_DISCOUNT_AMOUNT_TT', $product->prices);
					echo $currency->createPriceDiv ('taxAmount', 'COM_VIRTUEMART_PRODUCT_TAX_AMOUNT', $product->prices);
					echo $currency->createPriceDiv ('taxAmountTt', 'COM_VIRTUEMART_PRODUCT_TAX_AMOUNT_TT', $product->prices);
					
					$unitPriceDescription = vmText::sprintf ('COM_VIRTUEMART_PRODUCT_UNITPRICE', vmText::_('COM_VIRTUEMART_UNIT_SYMBOL_' . $product->product_unit));
					echo $currency->createPriceDiv ('unitPrice', $unitPriceDescription, $product->prices); ?>
				</div>
			<?php endif; ?>
		<?php endif; ?>
	</div>
<?php endif; ?>