<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

$_template          = plgSystemVPFrameworkHelper::getTemplate();
$params             = $_template->params;
$productModel       = VmModel::getModel('product');
$products           = $viewData['products'];
$cellWidth          = array();
$products_per_row   = (int) $viewData['products_per_row'];
$products_per_row   = !empty($products_per_row) ? $products_per_row : 1;
$products_per_row   = $params->get('vm_products_per_row_lg', $products_per_row);
$cellWidth[]        = 'col-lg-' . floor(12/$products_per_row);
$per_row_md         = $params->get('vm_products_per_row_md', 3);
$cellWidth[]        = 'col-md-' . floor(12/$per_row_md);
$per_row_sm         = $params->get('vm_products_per_row_sm', 2);
$cellWidth[]        = 'col-sm-' . floor(12/$per_row_sm);
$per_row_xs         = $params->get('vm_products_per_row_xs', 1);
$cellWidth[]        = 'col-xs-' . floor(12/$per_row_xs);
$cellWidth          = implode(' ', array_reverse($cellWidth));
$currency           = $viewData['currency'];
$showRating         = isset($viewData['showRating']) ? $viewData['showRating'] : 1;
$showRating         = $showRating && $params->get('vm_list_show_rating' , 1);
$showAddToCart      = isset($viewData['showAddToCart']) ? $viewData['showAddToCart'] : $params->get('vm_list_show_addtocart' , 1);
$showAddToCartHover = $showAddToCart && ($params->get('vm_list_show_addtocart' , 1) == 2);
$showPrice          = isset($viewData['showPrice']) ? $viewData['showPrice'] : 1;
$class              = 'product-listing mode-grid';
$isCategoryView     = isset($viewData['isCategoryView']) ? $viewData['isCategoryView'] : true;
$Itemid             = null;

if ($isCategoryView)
{
	$Itemid = method_exists('shopFunctionsF', 'getLastVisitedItemId') ? shopFunctionsF::getLastVisitedItemId() : null;
}

if($params->get('vm_image_product_lazyload', 0))
{
	$class .= ' lazyload-enabled';
}

if($params->get('vm_grid_equal_height', 1))
{
	$class .= ' equal-height';
}

$lg = 0;
$md = 0;
$sm = 0;
$xs = 0;
?>
<div class="<?php echo $class ?>">
	<?php if(!empty($products)) : ?>
		<?php
		$remaining = count($products);
		if($params->get('mouse_over_image_change', 1) && VmConfig::get('prodimg_browse', 1) < 2)
		{
			$productModel->addImages($products, 2);
		} ?>
		<div class="row">
		<?php foreach($products as $product) : ?>
			<?php 
			$lg++;
			$md++;
			$sm++;
			$xs++;
			$remaining--;
			$productLink = empty($product->link) ? $product->canonical : $product->link;
			$pItemid     = !$Itemid ? VPFrameworkVM::getMenuId($productLink) : $Itemid;
			$ItemidStr   = !empty($pItemid) ? '&Itemid=' . $pItemid : '';
			$productLink = JRoute::_($productLink . $ItemidStr);
			?>
			<div class="product product-item <?php echo $cellWidth ?>">
				<div class="product-inner">
					<a href="<?php echo $productLink; ?>">
						<?php echo shopFunctionsF::renderVmSubLayout('tags', array('product' => $product)); ?>
					</a>
					<div class="product-image-cont">
						<a href="<?php echo $productLink; ?>">
							<?php if($params->get('mouse_over_image_change') && isset($product->images[1])) : ?>
								<?php if($params->get('vm_image_product_lazyload', 0))
								{
									echo VPFrameworkVM::displayThumnbailLazily($product->images[0], $product->product_name, 'container-fit-image start-image load-lazily');
									echo '<div class="on-mouseover-image">';
									echo VPFrameworkVM::displayThumnbailLazily($product->images[1], $product->product_name, 'container-fit-image load-lazily');
									echo '</div>';
								}
								else
								{
									echo $product->images[0]->displayMediaThumb('class="responsive-image start-image"', false);
									echo '<div class="on-mouseover-image">';
									echo $product->images[1]->displayMediaThumb('class="responsive-image"', false);
									echo '</div>';
								} ?>
							<?php elseif(!empty($product->images[0])) : ?>
								<?php if($params->get('vm_image_product_lazyload', 0))
								{
									echo VPFrameworkVM::displayThumnbailLazily($product->images[0], $product->product_name, 'container-fit-image display-always-image load-lazily');
								}
								else
								{
									echo $product->images[0]->displayMediaThumb('class="responsive-image display-always-image"', false);
								} ?>
							<?php endif; ?>
						</a>
						<?php echo shopFunctionsF::renderVmSubLayout('productextras', array('product' => $product, 'showAddToCartHover' => $showAddToCartHover)); ?>
					</div>
					<div class="product-name-cont">
						<h3 class="product-name">
							<a href="<?php echo $productLink; ?>" title="<?php echo $product->product_name ?>" class="hover-invert"><?php echo $product->product_name ?></a>
						</h3>
					</div>
					<?php if($params->get('show_vm_list_category_name', 1) && !empty($product->category_name)) : ?>
						<div class="product-cat-name-cont">
							<span class="text-muted category-name"><?php echo $product->category_name; ?></span>
						</div>
					<?php endif; ?>
					<?php if($showRating && !empty($product->rating)) : ?>
					<div class="product-rating-cont">
						<?php echo shopFunctionsF::renderVmSubLayout('rating', array('showRating' => $showRating, 'product' => $product, 'addSchema' => false)); ?>
					</div>
					<?php endif; ?>
					<?php if($showPrice) : ?>
						<div class="product-price-cont">
							<?php echo shopFunctionsF::renderVmSubLayout('prices', array('product' => $product, 'currency' => $currency, 'addSchema' => false)); ?>
						</div>
					<?php endif; ?>
					<?php if($showAddToCart) : ?>
						<div class="product-addtocart-cont<?php echo ($params->get('vm_list_show_addtocart' , 1) == 2) ? ' hide' : ''; ?>">
							<?php echo shopFunctionsF::renderVmSubLayout('addtocart', array('product' => $product, 'isList' => true, 'listMode' => 'grid')); ?>
						</div>
					<?php endif; ?>
				</div>
			</div>
			<?php if($lg == $products_per_row) : ?>
				<div class="clearfix visible-lg"></div>
				<?php $lg = 0; ?>
			<?php elseif(empty($remaining)) : ?>
				<div class="clearfix visible-lg"></div>	
			<?php endif; ?>
			<?php if($md == $per_row_md) : ?>
				<div class="clearfix visible-md"></div>
				<?php $md = 0; ?>
			<?php elseif(empty($remaining)) : ?>
				<div class="clearfix visible-md"></div>
			<?php endif; ?>
			<?php if($sm == $per_row_sm) : ?>
				<div class="clearfix visible-sm"></div>
				<?php $sm = 0; ?>
			<?php elseif(empty($remaining)) : ?>
				<div class="clearfix visible-sm"></div>
			<?php endif; ?>
			<?php if($xs == $per_row_xs) : ?>
				<div class="clearfix visible-xs"></div>
				<?php $xs = 0; ?>
			<?php elseif(empty($remaining)) : ?>
				<div class="clearfix visible-xs"></div>
			<?php endif; ?>
		<?php endforeach; ?>
		</div>
	<?php endif; ?>
</div>