<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die('Restricted access');

if(!class_exists('VmHtml')) require(VMPATH_ADMIN . '/helpers/html.php');

$_prefix = $viewData['prefix'];
$field   = $viewData['field'];
$app     = JFactory::getApplication();

if($app->isClient('site'))
{
	if (!class_exists('VirtueMartCart')) require(VMPATH_SITE . '/helpers/cart.php');
	
	$cart = VirtuemartCart::getCart();
	$cart->prepareVendor();
	
	if(is_array($cart->BT) && !empty($cart->BT['tos']))
	{
		$tos = $cart->BT['tos'];
	}
	elseif(!empty($cart->cartfields) && is_array($cart->cartfields) && !empty($cart->cartfields['tos']))
	{
		$tos = $cart->cartfields['tos'];
	}
	else 
	{
		$tos = 0;
	}
} 
else 
{
	$tos = $field['value'];
}
?>
<?php if($app->isClient('site')) : ?>
	<?php if(VmConfig::get('oncheckout_show_legal_info', 1)) : ?>
		<div class="checkbox">
			<label for="tos">
				<?php echo VmHtml::checkbox($_prefix . $field['name'], $tos, 1, 0, 'class="terms-of-service required"', 'tos'); ?>
				<a href="#full-tos" class="terms-of-service" data-toggle="modal"><?php echo JText::_ ('COM_VIRTUEMART_CART_TOS_READ_AND_ACCEPTED'); ?></a>
			</label>
		</div>
		<div class="boot-modal fade" id="full-tos" tabindex="-1" role="dialog" aria-labelledby="tosModalLabel" aria-hidden="true">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						<h4 class="modal-title" id="tosModalLabel"><?php echo JText::_ ('COM_VIRTUEMART_CART_TOS'); ?></h4>
					</div>
					<div class="modal-body">
						<?php echo $cart->vendor->vendor_terms_of_service; ?>
					</div>
				</div>
			</div>
		</div>
	<?php else : ?>
		<div class="checkbox">
			<label>
				<?php echo VmHtml::checkbox($_prefix . $field['name'], $tos, 1, 0, 'class="terms-of-service required"', 'tos'); ?> <?php echo $field['title'] ?>
			</label>
		</div>
	<?php endif; ?>
<?php elseif($app->isClient('administrator')) : ?>
	<?php echo VmHtml::checkbox($_prefix . $field['name'], $tos, 1, 0, 'class="terms-of-service required"', 'tos'); ?>
<?php endif; ?>