<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined ('_JEXEC') or die;

JLoader::register('VirtueMartCart', VMPATH_SITE . '/helpers/cart.php');

$doc        = JFactory::getDocument();
$this->cart = VirtueMartCart::getCart();
$template   = plgSystemVPFrameworkHelper::getTemplate();

$url = 0;

if ($this->cart->_fromCart or $this->cart->getInCheckOut()) 
{
	$rview = 'cart';
}
else 
{
	$rview = 'user';
}

$task = '';
$url = JRoute::_('index.php?option=com_virtuemart&view=' . $rview . $task, $this->useXHTML, $this->useSSL);

if(count($this->userFields['functions']) > 0) 
{
	$doc->addScriptDeclaration(join("\n", $this->userFields['functions']));
}

// Load required validation scripts
VPFrameworkVM::addValidator();
?>
<section class="vm-user-address-edit-page">
	<div class="page-header">
		<h1><?php echo $this->page_title ?></h1>
	</div>
	<div class="vm-user-login-cont">
		<?php echo shopFunctionsF::getLoginForm (true, false, $url); ?>
	</div>
	<h2 class="sub-heading"><?php echo ($this->address_type == 'BT') ? vmText::_ ('COM_VIRTUEMART_USER_FORM_EDIT_BILLTO_LBL') : vmText::_ ('COM_VIRTUEMART_USER_FORM_ADD_SHIPTO_LBL'); ?></h2>
	<form method="post" id="userForm" name="userForm" class="form-validate form-horizontal old-form" action="<?php echo JRoute::_('index.php?option=com_virtuemart&view=user', $this->useXHTML, $this->useSSL) ?>">
		<?php echo $this->loadTemplate ('userfields'); ?>

		<?php if (VmConfig::get('reg_captcha') && JFactory::getUser()->guest) : ?>
			<fieldset id="recaptcha_wrapper">
				<div class="form-group">
					<label class="userfields_info control-label col-sm-3"><?php echo !VmConfig::get('oncheckout_only_registered') ? vmText::_ ('COM_VIRTUEMART_USER_FORM_CAPTCHA') : ''; ?></label>
					<div class="col-sm-9">
						<?php echo $this->captcha; ?>
					</div>
				</div>
			</fieldset>
		<?php endif; ?>
		
		<fieldset class="vm-user-form-buttons-cont">
			<div class="form-group">
				<div class="col-sm-offset-3 col-sm-9">
					<?php if(VmConfig::get('oncheckout_show_register', 1) && $this->userDetails->JUser->id == 0 && !VmConfig::get('oncheckout_only_registered', 0) && $this->address_type == 'BT' && $rview == 'cart') : ?>
						<p id="reg_text" class="bg-box bg-info">
							<?php echo vmText::sprintf('COM_VIRTUEMART_ONCHECKOUT_DEFAULT_TEXT_REGISTER', vmText::_('COM_VIRTUEMART_REGISTER_AND_CHECKOUT'), vmText::_('COM_VIRTUEMART_CHECKOUT_AS_GUEST')) ?>
						</p>
					<?php endif; ?>
					<?php if(VmConfig::get ('oncheckout_show_register', 1) && $this->userDetails->JUser->id == 0 && $this->address_type == 'BT' and $rview == 'cart') : ?>
						<button name="register" class="btn btn-base btn-lg" type="submit" onclick="javascript:return myValidator(userForm, true);" title="<?php echo vmText::_ ('COM_VIRTUEMART_REGISTER_AND_CHECKOUT'); ?>"><?php echo vmText::_ ('COM_VIRTUEMART_REGISTER_AND_CHECKOUT'); ?></button>
						<?php if (!VmConfig::get('oncheckout_only_registered', 0)) : ?>
							&nbsp;
							<button name="save" class="btn btn-base btn-lg" title="<?php echo vmText::_ ('COM_VIRTUEMART_CHECKOUT_AS_GUEST'); ?>" type="submit" onclick="javascript:return myValidator(userForm, false);"><?php echo vmText::_ ('COM_VIRTUEMART_CHECKOUT_AS_GUEST'); ?></button>
						<?php endif; ?>
						&nbsp;
						<button class="btn btn-default btn-lg" type="reset" onclick="window.location.href='<?php echo JRoute::_ ('index.php?option=com_virtuemart&view=' . $rview.'&task=cancel'); ?>'"><?php echo vmText::_ ('COM_VIRTUEMART_CANCEL'); ?></button>
					<?php else : ?>
						<button class="btn btn-base btn-lg" type="submit" onclick="javascript:return myValidator(userForm, true);"><?php echo vmText::_ ('COM_VIRTUEMART_SAVE'); ?></button>
						&nbsp;
						<button class="btn btn-default btn-lg" type="reset" onclick="window.location.href='<?php echo JRoute::_ ('index.php?option=com_virtuemart&view=' . $rview . '&task=cancel'); ?>'"><?php echo vmText::_ ('COM_VIRTUEMART_CANCEL'); ?></button>
					<?php endif; ?>
				</div>
			</div>
		</fieldset>

		<?php if($this->userDetails->JUser->get('id')) : ?>
			<?php echo $this->loadTemplate('addshipto'); ?>
		<?php endif; ?>
		
		<input type="hidden" name="option" value="com_virtuemart"/>
		<input type="hidden" name="view" value="user"/>
		<input type="hidden" name="controller" value="user"/>
		<input type="hidden" name="task" value="saveUser"/>
		<input type="hidden" name="layout" value="<?php echo $this->getLayout (); ?>"/>
		<input type="hidden" name="address_type" value="<?php echo $this->address_type; ?>"/>
		<?php if(!empty($this->virtuemart_userinfo_id)) : ?>
			<input type="hidden" name="shipto_virtuemart_userinfo_id" value="<?php echo (int) $this->virtuemart_userinfo_id ?>"/>
		<?php endif; ?>
		<?php echo JHtml::_('form.token'); ?>
	</form>
</section>