<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die('Restricted access');

JHtml::_('behavior.formvalidator');
	
$this->show       = !isset($this->show) ? true : $this->show;
$this->from_cart  = !isset($this->from_cart) ? true : $this->from_cart;
$this->order      = !isset($this->order) ? true : $this->order;
$url              = !empty($this->url) ? $this->url : vmURI::getCleanUrl();
$user             = JFactory::getUser();
$app              = JFactory::getApplication();
$input            = $app->input;

if($this->show && $user->guest) 
{
	JHtml::_('behavior.modal');

	if(JPluginHelper::isEnabled('authentication', 'openid'))
	{
		$lang = JFactory::getLanguage();
		$lang->load('plg_authentication_openid', JPATH_ADMINISTRATOR);
		$langScript = '
		//<![CDATA[
		'.'var JLanguage = {};' .
		                ' JLanguage.WHAT_IS_OPENID = \'' . vmText::_('WHAT_IS_OPENID') . '\';' .
		                ' JLanguage.LOGIN_WITH_OPENID = \'' . vmText::_('LOGIN_WITH_OPENID') . '\';' .
		                ' JLanguage.NORMAL_LOGIN = \'' . vmText::_('NORMAL_LOGIN') . '\';' .
		                ' var comlogin = 1;
		//]]>
		                ';
		vmJsApi::addJScript('login_openid',$langScript);
		JHtml::_('script', 'openid.js');
	}

	$html = '';
	JPluginHelper::importPlugin('vmpayment');
	$dispatcher = JDispatcher::getInstance();
	$returnValues = $dispatcher->trigger('plgVmDisplayLogin', array($this, &$html, $this->from_cart));

	if(is_array($html))
	{
		foreach($html as $login)
		{
			echo $login . '<br/>';
		}
	}
	else 
	{
		echo $html;
	} 
	// end plugins section ?>

	<?php
	// anonymous order section
	if($this->order) : ?>
		<div class="order-view">
			<h2 class="section-header"><?php echo vmText::_('COM_VIRTUEMART_ORDER_ANONYMOUS') ?></h2>
			<form action="<?php echo JRoute::_( 'index.php', 1, $this->useSSL); ?>" method="post" class="form-inline" role="form">
				<div class="form-group" id="com-form-order-number">
					<label class="control-label" for="order_number"><?php echo vmText::_('COM_VIRTUEMART_ORDER_NUMBER') ?></label>
					<input type="text" class="form-control" name="order_number" id="order_number" placeholder="<?php echo vmText::_('COM_VIRTUEMART_ORDER_NUMBER') ?>" value=""/>
				</div>
				<div class="form-group" id="com-form-order-pass">
					<label class="control-label" for="order_pass"><?php echo vmText::_('COM_VIRTUEMART_ORDER_PASS') ?></label>
					<input type="text" class="form-control" name="order_pass" id="order_pass" placeholder="<?php echo vmText::_('COM_VIRTUEMART_ORDER_PASS') ?>" value="p_"/>
				</div>
				<div class="form-group" id="com-form-order-submit">
					<button type="submit" class="btn btn-default" title="<?php echo vmText::_('COM_VIRTUEMART_ORDER_BUTTON_VIEW') ?>"><?php echo vmText::_('COM_VIRTUEMART_ORDER_BUTTON_VIEW') ?></button>
				</div>
				<input type="hidden" name="option" value="com_virtuemart" />
				<input type="hidden" name="view" value="orders" />
				<input type="hidden" name="layout" value="details" />
				<input type="hidden" name="return" value="" />
			</form>
		</div>
	<?php endif; 
	// end anonymous order section
	?>	
	
	<h2 class="section-header"><?php echo vmText::_('COM_VIRTUEMART_ORDER_CONNECT_FORM'); ?></h2>	
	<form id="com-form-login" action="<?php echo JRoute::_('index.php' . ($app->input->getCmd('tmpl') ? '?tmpl=' . $app->input->getCmd('tmpl') : ''), $this->useXHTML, $this->useSSL); ?>" method="post" class="form-validate form-inline" role="form">
		<div class="form-group">
			<?php if($input->getCmd('view') == 'cart' || $input->getCmd('view') == 'user') : ?>
				<div class="input-group">
					<span class="input-group-addon" id="username-label"><i class="icon-user2 icon-lg"></i></span>
					<input type="text" class="form-control" name="username" id="username" placeholder="<?php echo vmText::_('COM_VIRTUEMART_USERNAME'); ?>" value="" required="true" aria-describedby="username-label"/>
				</div>
			<?php else : ?>
				<label class="control-label" for="username"><?php echo vmText::_('COM_VIRTUEMART_USERNAME'); ?></label>
				<input type="text" class="form-control" name="username" id="username" placeholder="<?php echo vmText::_('COM_VIRTUEMART_USERNAME'); ?>" value="" required="true"/>
			<?php endif; ?>
		</div>
		<div class="form-group">
			<?php if($input->getCmd('view') == 'cart' || $input->getCmd('view') == 'user') : ?>
				<div class="input-group">
					<span class="input-group-addon" id="password-label"><i class="icon-key icon-lg"></i></span>
					<input type="password" class="form-control" name="password" id="password" placeholder="<?php echo vmText::_('COM_VIRTUEMART_PASSWORD'); ?>" value="" required="true" aria-describedby="password-label"/>
				</div>
			<?php else : ?>
				<label class="control-label" for="password"><?php echo vmText::_('COM_VIRTUEMART_PASSWORD'); ?></label>
				<input type="password" class="form-control" name="password" id="password" placeholder="<?php echo vmText::_('COM_VIRTUEMART_PASSWORD'); ?>" value="" required="true"/>
			<?php endif; ?>
		</div>
		<?php if($input->getCmd('view') == 'cart' || $input->getCmd('view') == 'user') : ?>
			<button class="btn btn-default" type="submit"><?php echo vmText::_('COM_VIRTUEMART_LOGIN') ?></button>
		<?php endif; ?>
		<?php if (JPluginHelper::isEnabled('system', 'remember')) : ?>
			<div class="checkbox">
				<label for="remember" class="checkbox-inline">
					<input type="checkbox" id="remember" name="remember" value="yes" />
					<?php echo vmText::_('JGLOBAL_REMEMBER_ME') ?>
				</label>
			</div>
		<?php endif; ?>
		<?php if($input->getCmd('view') != 'cart' && $input->getCmd('view') != 'user') : ?>
			<button class="btn btn-base" type="submit"><?php echo vmText::_('COM_VIRTUEMART_LOGIN') ?></button>
		<?php endif; ?>
		<input type="hidden" name="task" value="user.login" />
		<input type="hidden" name="option" value="com_users" />
		<input type="hidden" name="return" value="<?php echo base64_encode($url) ?>" />
		<?php echo JHtml::_('form.token'); ?>
	</form>

	<div class="login-page-system-links">
		<a href="<?php echo JRoute::_('index.php?option=com_users&view=remind'); ?>" rel="nofollow"><?php echo vmText::_('COM_VIRTUEMART_ORDER_FORGOT_YOUR_USERNAME'); ?></a>
		<?php if($input->getCmd('view') == 'cart') : ?>
			<span>&nbsp;/&nbsp;</span>
		<?php else : ?>
			<span>&nbsp;</span>
		<?php endif; ?>		
		<a href="<?php echo JRoute::_('index.php?option=com_users&view=reset'); ?>" rel="nofollow"><?php echo vmText::_('COM_VIRTUEMART_ORDER_FORGOT_YOUR_PASSWORD'); ?></a>
	</div>

<?php
}
elseif(!$user->guest)
{ ?>
	<form action="<?php echo JRoute::_('index.php'); ?>" method="post" id="form-logout" class="form-inline" role="form">
		<div class="form-group">
			<label class="sr-only"><?php echo vmText::sprintf( 'COM_VIRTUEMART_HINAME', $user->name ); ?></label>
			<p class="form-control-static"><?php echo vmText::sprintf( 'COM_VIRTUEMART_HINAME', $user->name ); ?></p>
		</div>
		<div class="form-group">
			<span class="hidden-xs">&nbsp;</span>
			<button type="submit" class="btn btn-default" title="<?php echo vmText::_( 'COM_VIRTUEMART_BUTTON_LOGOUT'); ?>"><?php echo vmText::_( 'COM_VIRTUEMART_BUTTON_LOGOUT'); ?></button>
		</div>	
		<input type="hidden" name="option" value="com_users" />
		<input type="hidden" name="task" value="user.logout" />
		<input type="hidden" name="return" value="<?php echo base64_encode($url) ?>" />
		<?php echo JHtml::_('form.token'); ?>
	</form>
<?php
} ?>

