<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die('Restricted access');
?>
<section class="vendor-details-view">
	<div class="page-header">
		<h1><?php echo $this->vendor->vendor_store_name ?></h1>
	</div>
	<div class="vendor-store-desc clearfix">
		<?php if(!empty($this->vendor->images[0])) : ?>
			<div class="vendor-image-cont">
				<?php echo $this->vendor->images[0]->displayMediaThumb('class="img-responsive"', false); ?>
			</div>
		<?php endif; ?>	
		<?php echo $this->vendor->vendor_store_desc; ?>
	</div>
	<div class="vendor-address-cont">
		<?php echo shopFunctionsF::renderVendorAddress($this->vendor->virtuemart_vendor_id); ?>
	</div>
	<div class="vendor-page-links">
		<ul class="list-inline">
			<li>
				<?php echo $this->linktos ?>
			</li>
			<li>
				<?php echo $this->linkcontact ?>
			</li>
		</ul>
	</div>	
</section>