<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

/**
 * Layout variables
 * ---------------------
 * 	$options         : (array)  Optional parameters
 * 	$label           : (string) The html code for the label (not required if $options['hiddenLabel'] is true)
 * 	$input           : (string) The input field html code
 */

if (!empty($displayData['options']['showonEnabled']))
{
	JHtml::_('jquery.framework');
	JHtml::_('script', 'jui/cms.js', false, true);
}

$global = VPFrameworkGlobal::getInstance();
$format = $global->getState('form.renderfields.format', null);
$fieldClass = isset($format['fieldClass']) ? $format['fieldClass'] : '';

$class = empty($displayData['options']['class']) ? "" : " " . $displayData['options']['class'];
$rel   = empty($displayData['options']['rel']) ? "" : " " .  $displayData['options']['rel'];
?>
<?php if(!empty($format)) : ?>
	<div class="form-group<?php echo $class; ?>"<?php echo $rel; ?>>
		<?php if (empty($displayData['options']['hiddenLabel'])) : ?>
			<?php echo $displayData['label']; ?>
		<?php endif; ?>
		<div class="<?php echo $fieldClass ?>"><?php echo $displayData['input']; ?></div>
	</div>
<?php else : ?>
	<div class="control-group<?php echo $class; ?>"<?php echo $rel; ?>>
		<?php if (empty($displayData['options']['hiddenLabel'])) : ?>
			<div class="control-label"><?php echo $displayData['label']; ?></div>
		<?php endif; ?>
		<div class="controls"><?php echo $displayData['input']; ?></div>
	</div>
<?php endif; ?>
