<?php
/**
 * @package    VirtueMart Essentials
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

// Initialize some variables
$app       = JFactory::getApplication();
$product   = isset($displayData['product']) ? $displayData['product'] : null;
$params    = isset($displayData['params']) ? $displayData['params'] : $app->getParams('com_vmessentials');
$iconOnly  = isset($displayData['iconOnly']) ? $displayData['iconOnly'] : false;
$url       = isset($displayData['url']) ? $displayData['url'] : null;
$iconClass = isset($displayData['iconClass']) ? $displayData['iconClass'] : '';
$btnClass  = isset($displayData['btnClass']) ? $displayData['btnClass'] : '';
?>
<a href="#" data-lity-target="<?php echo $url ?>" class="btn-vme hasTooltip <?php echo $btnClass ?> vme-quickview" title="<?php echo JText::_('COM_VMESSENTIALS_QUICKVIEW'); ?>" target="_blank" data-lity>
	<?php if(!empty($iconClass)) : ?>
		<i class="<?php echo $iconClass ?>"></i>
	<?php endif; ?>
	<?php if(!$iconOnly) : ?>
		<span><?php echo JText::_('COM_VMESSENTIALS_QUICKVIEW'); ?></span>
	<?php endif; ?>
</a>