<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('JPATH_BASE') or die;

use Joomla\Registry\Registry;

JLoader::register('TagsHelperRoute', JPATH_BASE . '/components/com_tags/helpers/route.php');

$authorised = JFactory::getUser()->getAuthorisedViewLevels();
?>
<?php if (!empty($displayData)) : ?>
	<?php if (version_compare(JVERSION, '4.0.0', 'ge')) : ?>
		<ul class="tags clearfix">
			<?php foreach ($displayData as $i => $tag) : ?>
				<?php if (in_array($tag->access, $authorised)) : ?>
					<?php $tagParams = new Registry($tag->params); ?>
					<?php $link_class = $tagParams->get('tag_link_class', ''); ?>
					<li class="tag-<?php echo $tag->tag_id; ?> tag-list<?php echo $i; ?>" itemprop="keywords">
						<a href="<?php echo JRoute::_(Joomla\Component\Tags\Site\Helper\RouteHelper::getTagRoute($tag->tag_id . ':' . $tag->alias)); ?>" class="<?php echo $link_class; ?>">
							<?php echo $this->escape($tag->title); ?>
						</a>
					</li>
				<?php endif; ?>
			<?php endforeach; ?>
		</ul>
	<?php else : ?>
		<ul class="tags clearfix">
			<?php foreach ($displayData as $i => $tag) : ?>
				<?php if (in_array($tag->access, JAccess::getAuthorisedViewLevels(JFactory::getUser()->get('id')))) : ?>
					<?php $tagParams = new Registry($tag->params); ?>
					<li class="tag-<?php echo $tag->tag_id; ?> tag-list<?php echo $i ?>" itemprop="keywords">
						<a href="<?php echo JRoute::_(TagsHelperRoute::getTagRoute($tag->tag_id . '-' . $tag->alias)) ?>">
							<?php echo $this->escape($tag->title); ?>
						</a>
					</li>
				<?php endif; ?>
			<?php endforeach; ?>
		</ul>
	<?php endif; ?>
<?php endif; ?>
