<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

$type              = ModModalLoginHelper::getType();
$return            = ModModalLoginHelper::getReturnURL($params, $type);
$twofactormethods  = ModModalLoginHelper::getTwoFactorMethods();
$user              = JFactory::getUser();
?>
<div class="boot-modal fade" id="modal-login-box" tabindex="-1" role="dialog" aria-labelledby="modalLoginLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>
				<h4 class="modal-title"><?php echo JText::_('JLOGIN') ?></h4>
			</div>
			<form action="<?php echo JRoute::_('index.php', true, $params->get('usesecure')); ?>" method="post" id="modal-login-form" role="form">
				<div class="modal-body">
					<?php if ($params->get('pretext')) : ?>
					<div class="pretext">
						<p><?php echo $params->get('pretext'); ?></p>
					</div>
					<?php endif; ?>
					<div class="form-group">
						<label for="modlgn-username" class="sr-only"><?php echo JText::_('MOD_MODAL_LOGIN_VALUE_USERNAME'); ?></label>
						<input id="modlgn-username" type="text" name="username" class="form-control" size="18" placeholder="<?php echo JText::_('MOD_MODAL_LOGIN_VALUE_USERNAME') ?>" />
					</div>
					<div class="form-group">
						<label for="modlgn-passwd" class="sr-only"><?php echo JText::_('JGLOBAL_PASSWORD') ?></label>
						<input id="modlgn-passwd" type="password" name="password" class="form-control" size="18" placeholder="<?php echo JText::_('JGLOBAL_PASSWORD') ?>" />
					</div>
					<?php if(count($twofactormethods) > 1): ?>
					<div class="form-group">
						<label for="modlgn-secretkey" class="sr-only"><?php echo JText::_('JGLOBAL_SECRETKEY'); ?></label>
						<input id="modlgn-secretkey" autocomplete="off" type="text" name="secretkey" class="form-control" size="18" placeholder="<?php echo JText::_('JGLOBAL_SECRETKEY') ?>" />
						<span class="btn width-auto hasTooltip" title="<?php echo JText::_('JGLOBAL_SECRETKEY_HELP'); ?>">
							<span class="icon-help"></span>
						</span>
					</div>		
					<?php endif; ?>
					<?php if (JPluginHelper::isEnabled('system', 'remember')) : ?>
					<div class="checkbox">
						<label for="modlgn-remember">
							<input id="modlgn-remember" type="checkbox" name="remember" value="yes"/>
							<?php echo JText::_('MOD_MODAL_LOGIN_REMEMBER_ME') ?>					
						</label> 
					</div>
					<?php endif; ?>
					<div class="form-group">
						<button type="submit" tabindex="0" name="Submit" class="btn btn-orange btn-block"><?php echo JText::_('JLOGIN') ?></button>
					</div>		
					<?php $usersConfig = JComponentHelper::getParams('com_users'); ?>
					<?php if ($usersConfig->get('allowUserRegistration')) : ?>
					<div class="form-group">
					<a href="<?php echo JRoute::_('index.php?option=com_users&view=registration&Itemid=' . UsersHelperRoute::getRegistrationRoute()); ?>" class="btn btn-grey btn-block"><?php echo JText::_('MOD_MODAL_LOGIN_REGISTER'); ?></a>
					</div>
					<?php endif; ?>		

					<?php if ($params->get('posttext')) : ?>
						<div class="posttext">
							<p><?php echo $params->get('posttext'); ?></p>
						</div>
					<?php endif; ?>
				</div>
			  <div class="modal-footer">
					<ul class="list-inline">
						<li>
							<a href="<?php echo JRoute::_('index.php?option=com_users&view=remind&Itemid=' . UsersHelperRoute::getRemindRoute()); ?>">
							<?php echo JText::_('MOD_MODAL_LOGIN_FORGOT_YOUR_USERNAME'); ?></a>
						</li>
						<li>
							<a href="<?php echo JRoute::_('index.php?option=com_users&view=reset&Itemid=' . UsersHelperRoute::getResetRoute()); ?>">
							<?php echo JText::_('MOD_MODAL_LOGIN_FORGOT_YOUR_PASSWORD'); ?></a>
						</li>
					</ul>
			  </div>	

				<input type="hidden" name="option" value="com_users" />
				<input type="hidden" name="task" value="user.login" />
				<input type="hidden" name="return" value="<?php echo $return; ?>" />
				<?php echo JHtml::_('form.token'); ?>
			</form>
		</div>
	</div>
</div>