<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

$active_name = null;

foreach($list as $language)
{
	if($language->active)
	{
		$active_name = $language->title_native;
	}
}
?>
<div class="mod-languages<?php echo !empty($moduleclass_sfx) ? $moduleclass_sfx : ''; ?>">
<?php if ($headerText && !$params->get('dropdown', 1)) : ?>
	<span class="pretext"><?php echo $headerText; ?></span>
<?php endif; ?>

<?php if ($params->get('dropdown', 1)) : ?>
	<div class="topbar-switch">
		<span class="topbar-switch-inner">
			<?php if($params->get('dropdown', 1)) : ?>
				<?php echo $headerText; ?>
			<?php endif; ?>
			<?php if($module->showtitle) : ?>
				<span class="text-muted"><?php echo $module->title ?>:</span>
			<?php endif; ?>
			<span class="topbar-switch-selected"><?php echo $active_name ?></span>
			<span class="fa fa-angle-down"></span>
		</span>	
		<ul class="topbar-switch-list">
			<?php foreach($list as $language) : ?>
				<li<?php echo $language->active ? ' class="active"' : '' ; ?>>
					<a href="<?php echo $language->link;?>">
						<?php echo JHtml::_('image', 'mod_languages/' . $language->image . '.gif', $language->title_native, array('title' => $language->title_native), true);?>
						<span><?php echo $language->title_native; ?></span>
					</a>
				</li>
			<?php endforeach; ?>
		</ul>
	</div>
<?php else : ?>
	<ul class="<?php echo $params->get('inline', 1) ? 'lang-inline' : 'lang-block';?>">
	<?php foreach ($list as $language) : ?>
		<?php if ($params->get('show_active', 0) || !$language->active):?>
			<li class="<?php echo $language->active ? 'lang-active' : '';?>" dir="<?php echo JLanguage::getInstance($language->lang_code)->isRTL() ? 'rtl' : 'ltr' ?>">
			<a href="<?php echo $language->link;?>">
			<?php if ($params->get('image', 1)):?>
				<?php echo JHtml::_('image', 'mod_languages/' . $language->image . '.gif', $language->title_native, array('title' => $language->title_native), true);?>
			<?php else : ?>
				<?php echo $params->get('full_name', 1) ? $language->title_native : strtoupper($language->sef);?>
			<?php endif; ?>
			</a>
			</li>
		<?php endif;?>
	<?php endforeach;?>
	</ul>
<?php endif; ?>

<?php if ($footerText) : ?>
	<span class="posttext"><?php echo $footerText; ?></span>
<?php endif; ?>
</div>
