<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

$class    = 'nav nav-pills nav-stacked';
$position = property_exists($module, 'position') ? $module->position : (isset($attribs['name']) ? $attribs['name'] : '');

if (!empty($position))
{
	if (in_array($position, array('left', 'right')))
	{
		$class = 'nav vpf-collapsible-menu sidebar-menu';
	}
	elseif (in_array($position, array('top-left', 'top-right')))
	{
		$class = 'nav list-inline';
	}
	elseif (in_array($position, array('footer-left', 'footer-right')))
	{
		$class = 'list-inline';
	}
}
// Note. It is important to remove spaces between elements.
?>
<?php // The menu class is deprecated. Use nav instead. ?>
<ul class="<?php echo $class . $class_sfx; ?>"<?php
	$tag = '';

	if ($params->get('tag_id') != null)
	{
		$tag = $params->get('tag_id') . '';
		echo ' id="' . $tag . '"';
	}
?>>
<?php
foreach ($list as $i => &$item)
{
	$class      = '';
	$itemParams = version_compare(JVERSION, '4.0.0', 'ge') ? $item->getParams() : $item->params;
	
	if ($item->type == 'vmcategory')
	{
		$class .= 'vmcategory vmcat-' . $item->virtuemart_category_id;
	}
	else
	{
		$class .= 'menuitem item-' . $item->id;
	}

	if (($item->id == $active_id) OR ($item->type == 'alias' AND $itemParams->get('aliasoptions') == $active_id))
	{
		$class .= ' current';
	}

	if (in_array($item->id, $path))
	{
		$class .= ' active';
	}
	elseif ($item->type == 'alias')
	{
		$aliasToId = $itemParams->get('aliasoptions');

		if (count($path) > 0 && $aliasToId == $path[count($path) - 1])
		{
			$class .= ' active';
		}
		elseif (in_array($aliasToId, $path))
		{
			$class .= ' alias-parent-active';
		}
	}
	elseif ($item->type == 'vmcategory')
	{
		if ($item->active)
		{
			$class .= ' active';
		}
	}
	
	if ($item->type == 'separator')
	{
		$class .= ' divider';
	}

	if ($item->deeper)
	{
		$class .= ' deeper';
		
		if (strpos($class, 'active') !== false)
		{
			$class .= ' open';
		}
	}

	if ($item->parent)
	{
		$class .= ' parent';
	}

	if (!empty($class))
	{
		$class = ' class="' . trim($class) . '"';
	}

	echo '<li' . $class . '>';

	// Render the menu item.
	switch ($item->type) :
		case 'separator':
		case 'url':
		case 'component':
		case 'heading':
			require JModuleHelper::getLayoutPath('mod_menu', 'default_' . $item->type);
			break;

		default:
			require JModuleHelper::getLayoutPath('mod_menu', 'default_url');
			break;
	endswitch;

	// The next item is deeper.
	if ($item->deeper)
	{
		echo '<ul class="nav-child">';
	}
	elseif ($item->shallower)
	{
		// The next item is shallower.
		echo '</li>';
		echo str_repeat('</ul></li>', $item->level_diff);
	}
	else
	{
		// The next item is on the same level.
		echo '</li>';
	}
}
?></ul>
