<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

if (!isset($module) && function_exists('debug_backtrace'))
{
	foreach (debug_backtrace() as $step)
	{
		if (isset($step['function']) && $step['function'] === 'dispatch' && isset($step['object']))
		{
			$reflection = new ReflectionClass($step['object']);
			
			if ($reflection->hasProperty('module'))
			{
				$property = $reflection->getProperty('module');

				$property->setAccessible(true);
				
				$module = $property->getValue($step['object']);
				
				break;
			}
		}
	}
}

$layoutParams                            = array();
$layoutParams['vm_category_parent_id']   = $params->get('Parent_Category_id', 0);
$layoutParams['vm_category_start_level'] = 1; // Start from 1st level
$layoutParams['vm_category_end_level']   = 0; // Get all levels
$layoutParams['show_vm_category_image']  = false; // We do not need images

$tmp = new JRegistry();
$tmp->loadArray($layoutParams);
$layoutParams = $tmp;

$categories = VPFrameworkVM::getCategories($layoutParams);
$active_id  = vRequest::getInt('virtuemart_category_id', 0);
$position   = property_exists($module, 'position') ? $module->position : (isset($attribs['name']) ? $attribs['name'] : '');
$class      = 'nav nav-pills nav-stacked';

if (!empty($position))
{
	if (in_array($position, array('left', 'right')))
	{
		$class = 'nav sidebar-menu';
	}
	elseif (in_array($position, array('footer-left', 'footer-right')))
	{
		$class = 'list-inline';
	}
	elseif (in_array($position, array('top-left', 'top-right')))
	{
		$class = 'nav list-inline';
	}
}
?>
<ul class="nav-vm-categories <?php echo $class . $class_sfx;?>">
<?php
foreach ($categories as $i => &$item)
{
	$class = 'vmcategory vmcat-' . $item->virtuemart_category_id;
	
	if ($item->active)
	{
		$class .= ' active';
	}

	if ($item->deeper)
	{
		$class .= ' deeper parent';
	}

	if (!empty($class))
	{
		$class = ' class="' . trim($class) . '"';
	}

	echo '<li' . $class . '>';

	// Note. It is important to remove spaces between elements.

	if ($item->params->get('show_image', 0) && $item->thumbnail)
	{
			$linktype = '<span class="menu-image">' . $item->thumbnail . '</span><span class="menu-title">' . $item->category_name . '</span>';
	}
	else
	{
		$linktype = '<span class="menu-title">' . $item->category_name . '</span>';
	}

	if ($item->deeper)
	{
		$linktype .= '<span class="opener"></span>';
	}

	$flink = $item->link;
	
	echo '<a ' . 'href="' . $flink . '">' . $linktype . '</a>';

	// The next item is deeper.
	if ($item->deeper)
	{
		echo '<ul class="nav-child">';
	}
	elseif ($item->shallower)
	{
		// The next item is shallower.
		echo '</li>';
		echo str_repeat('</ul></li>', $item->level_diff);
	}
	else
	{
		// The next item is on the same level.
		echo '</li>';
	}
}
?></ul>