<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined ('_JEXEC') or die('Restricted access');

vmJsApi::jPrice();

if($show_price && $show_addtocart)
{
	// We need to do this as standard VM Product Module 
	// does not load custom fields by default.
	$customfieldsModel = VmModel::getModel('Customfields');
	
	if(!class_exists('vmCustomPlugin'))
	{
		require(JPATH_VM_PLUGINS . '/vmcustomplugin.php');
	}
	
	foreach($products as $key => $productItem)
	{
		if(!empty($productItem->customfields))
		{
			$product = clone($productItem);
			$customfields = array();
			foreach($productItem->customfields as $cu)
			{
				$customfields[] = clone($cu);
			}
			$customfieldsSorted = array();
			$customfieldsModel->displayProductCustomfieldFE($product, $customfields);
			foreach ($customfields as $k => $custom)
			{
				if (!empty($custom->layout_pos))
				{
					$customfieldsSorted[$custom->layout_pos][] = $custom;
					unset($customfields[$k]);
				}
			}
			$customfieldsSorted['normal'] = $customfields;
			$product->customfieldsSorted = $customfieldsSorted;
			unset($product->customfields);
			$products[$key] = $product;
		}
		else
		{
			$products[$key] = $productItem;
		}
	}
}
// Do we need to show rating
$ratingModel = VmModel::getModel('ratings');
$showRating = $ratingModel->showRating();
// Prepare data for display
$viewData = array(
              'products' => $products,
              'currency' => $currency,
              'products_per_row' => $products_per_row,
              'showRating' => $showRating,
              'showAddToCart' => $show_price && $show_addtocart,
              'showPrice' => $show_price,
              'isCategoryView' => false
            );
?>
<div class="vm-product-module product-module<?php echo $params->get('moduleclass_sfx') ?>">
	<?php if($headerText) : ?>
		<div class="vmheader<?php echo $params->get('moduleclass_sfx') ?>">
			<?php echo $headerText ?>
		</div>
	<?php endif; ?>
	
	<?php echo shopFunctionsF::renderVmSubLayout('products', $viewData); ?>
	
	<?php if($footerText) : ?>
		<div class="vmfooter<?php echo $params->get('moduleclass_sfx') ?>">
			<?php echo $footerText ?>
		</div>
	<?php endif; ?>
</div>