<?php 
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

$output = '';

$inputClass = !empty($module->position) && $module->position == 'search' ? 'form-control input-lg search-query' : 'form-control search-query';
$btnClass   = !empty($module->position) && $module->position == 'search' ? 'btn btn-invert btn-lg' : 'btn btn-invert';

$keyword = vRequest::uword('keyword', false, ' ,-,+,.,_');
$field   = '<label for="mod_virtuemart_search" class="sr-only">' . $button_text . '</label>';
$field  .= '<input type="text" name="keyword" id="mod_virtuemart_search" maxlength="' . $maxlength . '" class="' . $inputClass . '"  size="' . $width . '" value="' . $keyword . '" placeholder="' . $text . '" required />';
$image   = JUri::base(true) . '/components/com_virtuemart/assets/images/vmgeneral/search.png' ;

if($button && ($button_pos == 'right' || $button_pos == 'left'))
{
	$output  = '<div class="input-group">';
}

if ($button) :

	if ($imagebutton) :
		$button = '<input type="image" value="' . $button_text . '" class="btn btn-transparent" src="' . $image . '" onclick="this.form.keyword.focus();"/>';
	else :
		$button = '<button type="submit" class="' . $btnClass . '" title="' . $button_text . '" onclick="this.form.keyword.focus();"><i class="fa fa-search"></i><span class="sr-only">' . $button_text . '</span></button>';
	endif;

	switch ($button_pos) :
	
		case 'top' :
			$output .= $button . '<br/>' . $field;
			break;

		case 'bottom' :
			$output .= $field . '<br/>' . $button;
			break;

		case 'right' :
			$button = '<div class="input-group-btn">' . $button . '</div>';
			$output .= $field . $button;
		break;

		case 'left' :
		default :
			$button = '<div class="input-group-btn">' . $button . '</div>';
			$output .= $button . $field;
		break;
		
	endswitch;

else: 

	$output .= $field;
	
endif;

if($button && ($button_pos == 'right' || $button_pos == 'left'))
{
	$output .= '</div>';
}

$category_id = $params->get('filter_category', 0) ? '' : '&virtuemart_category_id=0';
?>
<div class="product-search<?php echo $params->get('moduleclass_sfx'); ?>">
	<form action="<?php echo JRoute::_('index.php?option=com_virtuemart&view=category&search=true&limitstart=0' . $category_id); ?>" method="get" data-searchform>
		<?php echo $output; ?>
		<input type="hidden" name="option" value="com_virtuemart" />
		<input type="hidden" name="view" value="category" />
		<input type="hidden" name="limitstart" value="0" />
		<?php if(!empty($set_Itemid)) : ?>
			<input type="hidden" name="Itemid" value="<?php echo $set_Itemid ?>" />
		<?php endif; ?>
	</form>
</div>