<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

/*
 * Module chrome for rendering the module in a submenu
 */
function modChrome_no($module, &$params, &$attribs)
{
	if(!empty($module->content))
	{
		addModScript($module, $params, $attribs);
		
		echo '<div class="no-style-module-cont' . htmlspecialchars($params->get('moduleclass_sfx', '')) . '" data-mod-id="' . $module->id . '">';
		echo $module->content;
		echo '</div>';
	}
}

function modChrome_well($module, &$params, &$attribs)
{
	if (!empty($module->content))
	{
		addModScript($module, $params, $attribs);
		
		$moduleTag   = htmlspecialchars($params->get('module_tag', 'div'), ENT_QUOTES, 'UTF-8');
		$headerTag   = htmlspecialchars($params->get('header_tag', 'h3'), ENT_QUOTES, 'UTF-8');
		$headerClass = htmlspecialchars($params->get('header_class', 'mod-header'), ENT_COMPAT, 'UTF-8');
		
		echo '<' . $moduleTag . ' class="module-cont module-well' . htmlspecialchars($params->get('moduleclass_sfx', ''), ENT_COMPAT, 'UTF-8') . '" data-mod-id="' . $module->id . '">';
		echo '<div class="well">';
		
		if ($module->showtitle)
		{
			echo '<' . $headerTag . ' class="' . $headerClass . '">' . ($params->get('vpf_module_icon_class') ? '<i class="' . htmlspecialchars($params->get('vpf_module_icon_class')) . '"></i> ' : '') . $module->title . '</' . $headerTag . '>';
		}
		
		echo $module->content;
		echo '</div>';
		
		if($params->get('vpf_module_badge'))
		{
			echo '<span class="mod-badge badge badge-' . htmlspecialchars($params->get('vpf_module_badge_style')) . '">' . htmlspecialchars($params->get('vpf_module_badge')) . '</span>';
		}
		
		echo '</' . $moduleTag . '>';
	}
}

function modChrome_inline($module, &$params, &$attribs)
{
	if (!empty($module->content))
	{
		addModScript($module, $params, $attribs);
		
		$moduleTag   = htmlspecialchars($params->get('module_tag', 'div'), ENT_QUOTES, 'UTF-8');
		$headerClass = htmlspecialchars($params->get('header_class', 'topmod-title text-muted'), ENT_COMPAT, 'UTF-8');
		
		echo '<' . $moduleTag . ' class="inline-mod' . htmlspecialchars($params->get('moduleclass_sfx', ''), ENT_COMPAT, 'UTF-8') . '" data-mod-id="' . $module->id . '">';
		
		if ($module->showtitle)
		{
			echo '<div class="topmod-title text-muted">' . ($params->get('vpf_module_icon_class') ? '<i class="' . htmlspecialchars($params->get('vpf_module_icon_class')) . '"></i> ' : '') . $module->title . ':&nbsp;</div>';
		}
		
		echo '<div class="topmod-content">' . $module->content . '</div>';
		echo '</' . $moduleTag . '>';
	}
}

function modChrome_topright($module, &$params, &$attribs)
{
	if(!empty($module->content))
	{
		addModScript($module, $params, $attribs);
		
		$moduleTag = htmlspecialchars($params->get('module_tag', 'div'), ENT_QUOTES, 'UTF-8');
		
		echo '<' . $moduleTag . ' class="inline-mod right' . htmlspecialchars($params->get('moduleclass_sfx', ''), ENT_QUOTES, 'UTF-8') . '">';
		echo '<div class="topmod-content">' . $module->content . '</div>';
		echo '</' . $moduleTag . '>';
	}
}

function modChrome_row($module, &$params, &$attribs)
{
	if (!empty($module->content))
	{
		addModScript($module, $params, $attribs);
		
		$moduleTag     = htmlspecialchars($params->get('module_tag', 'div'), ENT_QUOTES, 'UTF-8');
		$headerTag     = htmlspecialchars($params->get('header_tag', 'h3'), ENT_QUOTES, 'UTF-8');
		$headerClass   = htmlspecialchars($params->get('header_class', 'mod-header'), ENT_COMPAT, 'UTF-8');
		$bootstrapSize = (int) $params->get('bootstrap_size', 0);
		$moduleClass   = $bootstrapSize !== 0 ? ' col-md-' . $bootstrapSize : '';
		
		echo '<div class="col-xs-12 vertical-module' . $moduleClass . '">';
		echo '<' . $moduleTag . ' class="module-cont module-row' . htmlspecialchars($params->get('moduleclass_sfx', ''), ENT_COMPAT, 'UTF-8') . '" data-mod-id="' . $module->id . '">';
		
		if ($module->showtitle)
		{
			echo '<' . $headerTag . ' class="' . $headerClass . '">' . ($params->get('vpf_module_icon_class') ? '<i class="' . htmlspecialchars($params->get('vpf_module_icon_class')) . '"></i> ' : '') . '<span class="mod-header-title">' . $module->title . '</span></' . $headerTag . '>';
		}
		
		echo $module->content;
		
		if($params->get('vpf_module_badge'))
		{
			echo '<span class="mod-badge badge badge-' . htmlspecialchars($params->get('vpf_module_badge_style')) . '">' . htmlspecialchars($params->get('vpf_module_badge')) . '</span>';
		}
		
		echo '</' . $moduleTag . '>';
		echo '</div>';
	}
}

function modChrome_autowidth($module, &$params, &$attribs)
{
	static $md = 0;
	static $sm = 0;
	static $xs = 0;
	static $remaining = null;
	
	$modPosition   = $attribs['name'];
	$modCount      = count(JModuleHelper::getModules($modPosition));
	$moduleTag     = htmlspecialchars($params->get('module_tag', 'div'), ENT_QUOTES, 'UTF-8');
	$headerTag     = htmlspecialchars($params->get('header_tag', 'h3'), ENT_QUOTES, 'UTF-8');
	$headerClass   = htmlspecialchars($params->get('header_class', 'mod-header'), ENT_COMPAT, 'UTF-8');
	$bootstrapSize = (int) $params->get('bootstrap_size', 0);
	$moduleClass   = $bootstrapSize !== 0 ? 'col-md-' . $bootstrapSize : 'col-md-' . floor(12/$modCount);
	
	if($remaining === null)
	{
		$remaining = $modCount;
	}
	
	if($modCount > 1)
	{
		$moduleClass .= ' col-sm-6';
	}

	$moduleClass .= ' col-xs-12';
	
	$remaining--;

	if (!empty($module->content))
	{
		$md++;
		$sm++;
		$xs++;
		
		addModScript($module, $params, $attribs);
		
		echo '<div class="' . $moduleClass . ' horizontal-module">';
		echo '<' . $moduleTag . ' class="module-cont module-autowidth' . htmlspecialchars($params->get('moduleclass_sfx', ''), ENT_COMPAT, 'UTF-8') . '" data-mod-id="' . $module->id . '">';
		
		if ($module->showtitle)
		{
			echo '<' . $headerTag . ' class="' . $headerClass . '">' . ($params->get('vpf_module_icon_class') ? '<i class="' . htmlspecialchars($params->get('vpf_module_icon_class')) . '"></i> ' : '') . '<span class="mod-header-title">' . $module->title . '</span></' . $headerTag . '>';
		}
		
		echo $module->content;
		
		if($params->get('vpf_module_badge'))
		{
			echo '<span class="mod-badge badge badge-' . htmlspecialchars($params->get('vpf_module_badge_style')) . '">' . htmlspecialchars($params->get('vpf_module_badge')) . '</span>';
		}
		
		echo '</' . $moduleTag . '>';
		echo '</div>';
		
		if($md == $modCount)
		{
			echo '<div class="clearfix visible-md visible-lg"></div>';
			$md = 0;
		}
		elseif(empty($remaining)) 
		{
			echo '<div class="clearfix visible-md visible-lg"></div>';
		}

		if($sm == 2)
		{
			echo '<div class="clearfix visible-sm"></div>';
			$sm = 0;
		}
		elseif(empty($remaining))
		{
			echo '<div class="clearfix visible-sm"></div>';
		}

		if($xs == 1) 
		{
			echo '<div class="clearfix visible-xs"></div>';
			$xs = 0;
		}
		elseif(empty($remaining)) 
		{
			echo '<div class="clearfix visible-xs"></div>';
		}
	}
}

function modChrome_block($module, &$params, &$attribs)
{
	if (!empty($module->content))
	{
		addModScript($module, $params, $attribs);
		
		$moduleTag   = htmlspecialchars($params->get('module_tag', 'div'), ENT_QUOTES, 'UTF-8');
		$headerTag   = htmlspecialchars($params->get('header_tag', 'h3'), ENT_QUOTES, 'UTF-8');
		$headerClass = htmlspecialchars($params->get('header_class', 'mod-header'), ENT_COMPAT, 'UTF-8');
		
		echo '<' . $moduleTag . ' class="module-cont module-block' . htmlspecialchars($params->get('moduleclass_sfx', ''), ENT_COMPAT, 'UTF-8') . '" data-mod-id="' . $module->id . '">';
		
		if ($module->showtitle)
		{
			echo '<' . $headerTag . ' class="' . $headerClass . '">' . ($params->get('vpf_module_icon_class') ? '<i class="' . htmlspecialchars($params->get('vpf_module_icon_class')) . '"></i> ' : '') . '<span class="mod-header-title">' . $module->title . '</span></' . $headerTag . '>';
		}
		
		echo $module->content;
		
		if($params->get('vpf_module_badge'))
		{
			echo '<span class="mod-badge badge badge-' . htmlspecialchars($params->get('vpf_module_badge_style')) . '">' . htmlspecialchars($params->get('vpf_module_badge')) . '</span>';
		}
		
		echo '</' . $moduleTag . '>';
	}
}

function modChrome_normal($module, &$params, &$attribs)
{
	if (!empty($module->content))
	{
		addModScript($module, $params, $attribs);
		
		$moduleTag   = htmlspecialchars($params->get('module_tag', 'div'), ENT_QUOTES, 'UTF-8');
		$headerTag   = htmlspecialchars($params->get('header_tag', 'h3'), ENT_QUOTES, 'UTF-8');
		$headerClass = htmlspecialchars($params->get('header_class', 'mod-header'), ENT_COMPAT, 'UTF-8');
		
		echo '<' . $moduleTag . ' class="module-cont' . htmlspecialchars($params->get('moduleclass_sfx', ''), ENT_QUOTES, 'UTF-8') . '" data-mod-id="' . $module->id . '">';
		
		if ($module->showtitle)
		{
			echo '<' . $headerTag . ' class="' . $headerClass . '">' . ($params->get('vpf_module_icon_class') ? '<i class="' . htmlspecialchars($params->get('vpf_module_icon_class')) . '"></i> ' : '') . $module->title . '</' . $headerTag . '>';
		}
		
		echo $module->content;
		
		if($params->get('vpf_module_badge'))
		{
			echo '<span class="mod-badge badge badge-' . htmlspecialchars($params->get('vpf_module_badge_style')) . '">' . htmlspecialchars($params->get('vpf_module_badge')) . '</span>';
		}
		
		echo '</' . $moduleTag . '>';
	}
}

function addModScript($module, $params, $attribs)
{
	$script = null;
	
	if($params->get('scroll-reveal', 0))
	{
		$options = array(
		  'origin' => $params->get('sr-origin', 'bottom'),
		  'distance' => $params->get('sr-distance', '20px'),
		  'duration' => (int) $params->get('sr-duration', 500),
		  'delay' => (int) $params->get('sr-delay', 0),
		  'opacity' => (float) $params->get('sr-opacity', 0),
		  'scale' => (float) $params->get('sr-scale', 0.9),
		  'easing' => $params->get('sr-easing', 'ease'),
		  'mobile' => (bool) $params->get('sr-mobile', 1),
		  'reset' => (bool) $params->get('sr-reset', 0),
		  'useDelay' => $params->get('sr-useDelay', 'always'),
		  'viewFactor' => (float) $params->get('sr-viewFactor', 0.2)
		);
		
		$options = (object) $options;
		$options = json_encode($options);
		
		$script = 'sr.reveal(\'[data-mod-id="' . $module->id . '"]\', ' . $options . ');';
		
		VPFrameworkScript::addScriptDeclaration($script, 'text/javascript', 'mod-sr', true, false);
	}
}