<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

if (version_compare(JVERSION, '4.0.0', 'ge'))
{
	JFactory::getDocument()->getWebAssetManager()->usePreset('qrcode');

	$js = "
	(function(document)
	{
		document.addEventListener('DOMContentLoaded', function()
		{
			var totpQrCodeElement = document.getElementById('totp-qrcode');

			// There's no QR Code element on the view profile page so ensure we don't get any errors
			if (totpQrCodeElement) {
				var qr = qrcode(0, 'H');
				qr.addData('" . $url . "');
				qr.make();
		
				totpQrCodeElement.innerHTML = qr.createImgTag(4);
			}
		});
	})(document);
	";
	
	JFactory::getDocument()->addScriptDeclaration($js);
}
else
{
	JHtml::_('script', 'plg_twofactorauth_totp/qrcode.min.js', array('version' => 'auto', 'relative' => true));

	$js = "
	(function(document)
	{
		document.addEventListener('DOMContentLoaded', function()
		{
			var qr = qrcode(0, 'H');
			qr.addData('" . $url . "');
			qr.make();

			document.getElementById('totp-qrcode').innerHTML = qr.createImgTag(4);
		});
	})(document);
	";

	JFactory::getDocument()->addScriptDeclaration($js);
}
?>
<input type="hidden" name="jform[twofactor][totp][key]" value="<?php echo $secret ?>" />

<div class="well">
	<?php echo JText::_('PLG_TWOFACTORAUTH_TOTP_INTRO') ?>
</div>

<fieldset>
	<legend><?php echo JText::_('PLG_TWOFACTORAUTH_TOTP_STEP1_HEAD') ?></legend>
	<p><?php echo JText::_('PLG_TWOFACTORAUTH_TOTP_STEP1_TEXT') ?></p>
	<ul>
		<li>
			<a href="<?php echo JText::_('PLG_TWOFACTORAUTH_TOTP_STEP1_ITEM1_LINK') ?>" target="_blank"><?php echo JText::_('PLG_TWOFACTORAUTH_TOTP_STEP1_ITEM1') ?></a>
		</li>
		<li>
			<a href="<?php echo JText::_('PLG_TWOFACTORAUTH_TOTP_STEP1_ITEM2_LINK') ?>" target="_blank"><?php echo JText::_('PLG_TWOFACTORAUTH_TOTP_STEP1_ITEM2') ?></a>
		</li>
	</ul>
	<p class="bg-box bg-warning"><?php echo JText::_('PLG_TWOFACTORAUTH_TOTP_STEP1_WARN') ?></p>
</fieldset>
<fieldset>
	<legend>
		<?php echo JText::_('PLG_TWOFACTORAUTH_TOTP_STEP2_HEAD') ?>
	</legend>
	<div class="row">
		<div class="col-sm-6">
			<p><?php echo JText::_('PLG_TWOFACTORAUTH_TOTP_STEP2_TEXT') ?></p>
			<table class="table table-striped">
				<tr>
					<td>
						<?php echo JText::_('PLG_TWOFACTORAUTH_TOTP_STEP2_ACCOUNT') ?>
					</td>
					<td>
						<?php if (version_compare(JVERSION, '4.0.0', 'ge')) : ?>
							<?php echo $sitename ?>/<?php echo $username ?>
						<?php else : ?>
							<?php echo $username ?>@<?php echo $hostname ?>
						<?php endif; ?>
					</td>
				</tr>
				<tr>
					<td>
						<?php echo JText::_('PLG_TWOFACTORAUTH_TOTP_STEP2_KEY') ?>
					</td>
					<td>
						<?php echo $secret ?>
					</td>
				</tr>
			</table>
		</div>
		<div class="col-sm-6">
			<p><?php echo JText::_('PLG_TWOFACTORAUTH_TOTP_STEP2_ALTTEXT') ?>
				<br /><div id="totp-qrcode"></div>
			</p>
		</div>
	</div>
	<p class="bg-box bg-info"><?php echo JText::_('PLG_TWOFACTORAUTH_TOTP_STEP2_RESET') ?></p>
</fieldset>
<?php if ($new_totp): ?>
<fieldset>
	<legend>
		<?php echo JText::_('PLG_TWOFACTORAUTH_TOTP_STEP3_HEAD') ?>
	</legend>
	<p><?php echo JText::_('PLG_TWOFACTORAUTH_TOTP_STEP3_TEXT') ?></p>
	<div class="form-group">
		<label class="control-label" for="totpsecuritycode"><?php echo JText::_('PLG_TWOFACTORAUTH_TOTP_STEP3_SECURITYCODE') ?></label>
		<input type="text" class="form-control" name="jform[twofactor][totp][securitycode]" id="totpsecuritycode" autocomplete="0">
	</div>
</fieldset>
<?php endif; ?>