<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */
defined('_JEXEC') or die;

$body_script = $params->get('body_script', '');

if(!empty($body_script) && strpos($body_script, 'google-analytics.com') !== false && strpos($body_script, '<script') === false)
{
	$body_script = '<script type="text/javascript">' . PHP_EOL . trim($body_script) . PHP_EOL . '</script>';
}
?>
<!DOCTYPE html>
<html lang="<?php echo $this->language; ?>" dir="<?php echo $this->direction; ?>" class="<?php echo $htmlClass ?>">
<?php require $template->loadBlock('head'); ?>
<body>
	<div class="vpf-wrapper">
		<?php if(!$isMinimal) : ?>
			<?php require $template->loadBlock('topbar'); ?>
			<?php require $template->loadBlock('header'); ?>
			<?php require $template->loadBlock('slider'); ?>
		<?php endif; ?>
		
		<?php require $template->loadBlock('breadcrumbs'); ?>
		<?php require $template->loadBlock('mainbody'); ?>
		
		<?php if(!$isMinimal) : ?>
			<?php require $template->loadBlock('utility'); ?>
			<?php require $template->loadBlock('bottom'); ?>
			<?php require $template->loadBlock('footer'); ?>
			<?php if($this->params->get('show_scroll_to_top', 1)) : ?>
				<button type="button" class="vpf-scroll-top-button hidden-xs hidden-sm" data-scroll="top" title="<?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_SCROLL_TOP_TOP') ?>">
					<span class="sr-only"><?php echo JText::_('PLG_SYSTEM_VPFRAMEWORK_SCROLL_TOP_TOP') ?></span><i class="fa fa-angle-up" aria-hidden="true"></i>
				</button>
			<?php endif; ?>
		<?php endif; ?>
	</div>
	<?php if(!$isMinimal) : ?>
		<div id="footer-toolbar" class="hidden-md hidden-lg"></div>
		<?php if($this->params->get('responsive', 1) && $this->params->get('offcavas', 1)) : ?>
			<?php require $template->loadBlock('offcanvas'); ?>
		<?php endif; ?>
		<?php echo JLayoutHelper::render('merchant.modallogin', array('params' => $this->params)); ?>
		<?php if($this->params->get('cookieconsent', 1) && !$template->getCookieConsent()) : ?>
			<?php require $template->loadBlock('cookieconsent'); ?>
		<?php endif; ?>
		<jdoc:include type="modules" name="debug" style="none"/>
    <?php echo $body_script; ?>
	<?php endif; ?>
<vpf:include type="script" />
</body>
</html>