<?php
/**
 *---------------------------------------------------------------------------------------
 * @package       VP Smart Template
 *---------------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       Abhishek Das
 * @email         info@virtueplanet.com
 * @link          https://www.virtueplanet.com
 *---------------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

require_once JPATH_ADMINISTRATOR . '/components/com_users/helpers/users.php';

$twofactormethods = UsersHelper::getTwoFactorMethods();
?>
<!DOCTYPE html>
<html lang="<?php echo $this->language; ?>" dir="<?php echo $this->direction; ?>" class="<?php echo $htmlClass ?>">
  <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8" />
    <meta http-equiv="x-ua-compatible" content="IE=edge" />
    <meta name="handheldfriendly" content="true" />
    <meta name="apple-touch-fullscreen" content="yes" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title><?php echo $this->title; ?></title>
    <link href="<?php echo $template->uri ?>/favicon.ico" rel="shortcut icon" type="image/vnd.microsoft.icon" />
    <link rel="stylesheet" href="<?php echo $template->media_uri ?>/css/bootstrap.min.css" type="text/css" />
    <link rel="stylesheet" href="<?php echo $template->uri ?>/css/offline.css" type="text/css" />
  </head>
  <body>
    <div class="container offline-container">
      <jdoc:include type="message" />
      <div class="outline">
        <div class="branding">
          <?php if ($app->get('offline_image') && file_exists($app->get('offline_image'))) : ?>
            <img src="<?php echo $this->baseurl . '/' . $app->get('offline_image'); ?>" class="img-responsive" alt="<?php echo htmlspecialchars($app->get('sitename')); ?>" />
          <?php elseif($params->get('logoFile')) : ?>
            <img src="<?php echo $this->baseurl . '/' . $template->getLogoImage($params->get('logoFile')) ?>" class="img-responsive" alt="<?php echo htmlspecialchars($app->get('sitename')); ?>" />
          <?php else : ?>
            <h1><?php echo $app->get('sitename'); ?></h1>
          <?php endif; ?>
        </div>
        <div class="message">
          <?php if ($app->get('display_offline_message', 1) == 1 && str_replace(' ', '', $app->get('offline_message')) != '') : ?>
            <p><?php echo $app->get('offline_message'); ?></p>
          <?php elseif ($app->get('display_offline_message', 1) == 2 && str_replace(' ', '', JText::_('JOFFLINE_MESSAGE')) != '') : ?>
            <p><?php echo JText::_('JOFFLINE_MESSAGE'); ?></p>
          <?php endif; ?>
          <hr />
        </div>
        <div class="login-section">
          <form action="<?php echo JRoute::_('index.php', true); ?>" method="post" id="form-login" role="form">
            <div class="row">
              <div class="col-sm-6">
                <div class="form-group">
                  <label class="control-label" for="username"><?php echo JText::_('JGLOBAL_USERNAME'); ?></label>
                  <input type="text" name="username" id="username" class="form-control" size="18" placeholder="<?php echo JText::_('JGLOBAL_USERNAME'); ?>" />
                </div>
              </div>
              <div class="col-sm-6">
                <div class="form-group">
                  <label class="control-label" for="password"><?php echo JText::_('JGLOBAL_PASSWORD'); ?></label>
                  <input type="password" name="password" id="password" class="form-control" size="18" placeholder="<?php echo JText::_('JGLOBAL_PASSWORD'); ?>" />
                </div>
              </div>
              <?php if (count($twofactormethods) > 1) : ?>
                <div class="col-sm-6">
                  <div class="form-group">
                  <label class="control-label" for="secretkey"><?php echo JText::_('JGLOBAL_SECRETKEY'); ?></label>
                  <input type="text" name="secretkey" id="secretkey" class="form-control" size="18" placeholder="<?php echo JText::_('JGLOBAL_SECRETKEY'); ?>" />
                  </div>
                </div>
              <?php endif; ?>
            </div>
            <div class="login-actions">
              <?php if (JPluginHelper::isEnabled('system', 'remember')) : ?>
                <div class="checkbox">
                  <label for="modal-login-remember">
                    <input id="modal-login-remember" type="checkbox" name="remember" value="yes" />
                    <?php echo JText::_('JGLOBAL_REMEMBER_ME') ?>
                  </label> 
                </div>
              <?php endif; ?>
              <button type="submit" class="btn btn-lg btn-primary"><?php echo JText::_('JLOGIN'); ?></button>
            </div>
            <input type="hidden" name="option" value="com_users" />
            <input type="hidden" name="task" value="user.login" />
            <?php echo JHtml::_('form.token') . $doc->_getLineEnd(); ?>
            <input type="hidden" name="return" value="<?php echo base64_encode(JUri::base()); ?>" />
          </form>
        </div>
      </div>
    </div>
    <?php if (version_compare(JVERSION, '4.0.0', 'ge')) : ?>
      <script src="<?php echo $this->baseurl; ?>/media/vendor/jquery/js/jquery.min.js" type="text/javascript"></script>
    <?php else : ?>
      <script src="<?php echo $this->baseurl; ?>/media/jui/js/jquery.min.js" type="text/javascript"></script>
    <?php endif; ?>
    <script src="<?php echo $template->media_uri ?>/js/bootstrap.min.js" type="text/javascript"></script>
  </body>
</html>